% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aco.cores.R
\name{initNodeList}
\alias{initNodeList}
\title{Initialize node list for ACO search space}
\usage{
initNodeList(search.space, phi0)
}
\arguments{
\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{phi0}{A non-negative numeric value. Initial pheromone value assigned
to all nodes at the start of the search. Defaults to 2.}
}
\value{
A data.frame in which each row represents an edge in the ACO
path-construction graph, with the following columns:
\describe{
\item{travel}{Integer. Travel counter associated with the edge,
initialized to zero.}
\item{node.no}{Integer. Decision node identifier corresponding to
a model feature.}
\item{node.name}{Character. Semantic label of the decision node.}
\item{edge.no}{Integer. Global edge index.}
\item{local.edge.no}{Integer. Index of the edge within the
corresponding decision node.}
\item{edge.name}{Character. Semantic label of the edge (model
component choice).}
\item{phi}{Numeric. Initial pheromone value associated with the
edge.}
\item{delta_phi}{Numeric. Change in pheromone level, initialized
to zero.}
\item{p}{Numeric. Initial selection probability of the edge.}
}
}
\description{
Construct the initial edge list used in model structure search
based on ant colony optimization.
}
\examples{
initNodeList(search.space = "ivbase", phi0 = 1)
initNodeList(search.space = "oralbase", phi0 = 1)

}
\author{
Zhonghui Huang
}
