% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsims.R
\name{nsims.nlists}
\alias{nsims.nlists}
\title{Number of Simulations}
\usage{
\method{nsims}{nlists}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
An integer scalar of the number of simulations.
}
\description{
Gets the number of simulations (iterations * chains)
of an MCMC object.

The default methods returns the product of \code{\link[universals:nchains]{nchains()}} and \code{\link[universals:niters]{niters()}}.
}
\examples{
nsims(nlists(nlist(x = c(2, 9)), nlist(x = c(1, 7))))
nsims(split_chains(nlists(nlist(x = c(2, 9)), nlist(x = c(1, 7)))))
}
\seealso{
Other MCMC dimensions: 
\code{\link[universals]{nchains}()},
\code{\link[universals]{niters}()},
\code{\link[universals]{npars}()},
\code{\link[universals]{nsams}()},
\code{\link[universals]{nterms}()}
}
