% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npdims.R
\name{npdims.nlist}
\alias{npdims.nlist}
\title{Number of Parameter Dimensions}
\usage{
\method{npdims}{nlist}(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Other arguments passed to methods.}
}
\value{
A named integer vector of the number of dimensions of each parameter.
}
\description{
Gets the number of the dimensions of each parameter of an object.

The default methods returns the length of each element of \code{\link[universals:pdims]{pdims()}}
as an integer vector.
}
\examples{
npdims(nlist(x = 1:3))
npdims(nlist(y = 3, zz = matrix(2:5, 2)))
}
\seealso{
Other dimensions: 
\code{\link[universals]{dims}()},
\code{\link[universals]{ndims}()},
\code{\link[universals]{pdims}()}
}
