% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadratureRules.R
\name{quadRule_GH}
\alias{quadRule_GH}
\title{Gauss-Hermite Quadrature Rule for Laplace and Approx Posteriors}
\usage{
quadRule_GH(type = "GHe")
}
\arguments{
\item{type}{Choose type of Gauss-Hermite nodes and weights. Defaults to \code{"GHe"}.}
}
\description{
Generate a 1 dimension GHQ grid via a nimble function list.
}
\details{
This function a 1D Gauss-Hermite Quadrature Grid (nodes and weights). When choosing `type = "GHe"`, 
the nodes and weights are to integrate a general function. If `type = "GHN"`,
the weights are multiplied by a standard normal. It cannot be compiled without being included within 
a virtual nimble list "QUAD_RULE_BASE".
}
\references{
\enc{Jäckel}{Jaeckel}, P. (2005). A note on multivariate Gauss-Hermite quadrature. London: ABN-Amro. Re.
Liu, Q. and Pierce, D. (1994) A Note on Gauss-Hermite Quadrature. Biometrika, 83, 624-629.
}
\author{
Paul van Dam-Bates
}
