% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tracts}
\alias{tracts}
\alias{tract_auxiliaries}
\alias{plots}
\alias{psus}
\alias{category_psu_map}
\title{Sample data on cover of lawns from the NILS, 2024.}
\format{
\subsection{\code{tracts}}{

A matrix with 300 rows (tracts)
\describe{
\item{tid}{the tract id number}
\item{psu}{the id number of the collection of primary sampling units (PSU) of the tract}
}
}

\subsection{\code{tract_auxiliaries}}{

A matrix with 300 rows (auxiliary information about the tracts)
\describe{
\item{x}{longitude of the tract centre}
\item{y}{latitude of the tract centre}
\item{elev_max}{the tract's maximum elevation}
\item{elev_range}{the tract's elevation range}
\item{nmd_artificial}{the area of the tract covered by buildings}
\item{nmd_open_land}{the area of the tract covered by open land}
\item{nmd_forest}{the area of the tract covered by forest}
\item{nmd_mountain_forest}{the area of the tract covered by low-growth mountain forest}
\item{wetness_mean}{the tract's mean wetness}
\item{decidiuous_sum}{the area of the tract covered by deciduous forest}
\item{arable}{the area of the tract covered by arable land}
\item{pasture}{the area of the tract covered by pasture}
}
}

\subsection{\code{plots}}{

A matrix with 16 rows (plots)
\describe{
\item{tid}{the tract id number of the tract containing this plot}
\item{cat}{the category (stratum) of the plot}
\item{dw}{the conditional design weight of the plot (inverse inclusion probability)}
\item{y}{the variable of interest -- the area of the (r=10) plot covered by grassland}
}
}

\subsection{\code{psus}}{

A length 2 ordered vector of PSU collection id numbers, ranging from the largest PSU level to the
smallest PSU level
}

\subsection{\code{category_psu_map}}{

A matrix with 2 rows (categories), containing the mapping of the largest PSU that the category
map to.
\describe{
\item{category}{the category (stratum) id number}
\item{psu}{the id number of the largest PSU that the category can be observed in}
}
}
}
\source{
\url{https://www.slu.se/om-slu/organisation/institutioner/skoglig-resurshushallning/miljoanalys/nils/}
}
\usage{
tracts

tract_auxiliaries

plots

psus

category_psu_map
}
\description{
The dataset includes information collected in the southern boreal region of Sweden (i.e. the
boreal region South of the Dal River).
}
\details{
This sample is a reduced version of the original data, containing only the two sparsest
subsamples and the two strata (selection classes/categories) sampled within them.
}
\keyword{datasets}
