% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_layman.R
\name{extract_layman}
\alias{extract_layman}
\title{extract Layman metrics}
\usage{
extract_layman(
  data,
  type = NULL,
  community_df = NULL,
  data_format = NULL,
  isotope_x = NULL,
  isotope_y = NULL,
  element_x = NULL,
  element_y = NULL
)
}
\arguments{
\item{data}{a \code{list} created by the function \code{bayesianLayman()} from the package
\href{https://CRAN.R-project.org/package=SIBER}{{SIBER}}.}

\item{type}{a \code{character} that is either \code{"bay"} or \code{"ml"} which indicates
whether the community metrics to be extracted are from a Bayesian analysis or
a maximum-likelihood.}

\item{community_df}{a two column data frame. One of the columns has to be named
\code{community} and the data in the column will be \code{numerics} as a \code{character}
string(e.g., \verb{"1", "2", "3"}). This is the order of the community names
and will be used to join the actual community names to the correct data.
These are the same class and values required by the function, \code{createSiberObject()}
from \href{https://CRAN.R-project.org/package=SIBER}{{SIBER}}.
The second column contains the actual names of the communities
that the user is working with (e.g., \code{"region"}).}

\item{data_format}{a \code{character} string that decides whether the returned object is
in long or wide format. Default is \code{"long"}, with the alternative supplied being \code{"wide"}.}

\item{isotope_x}{a \code{numeric} that will be used in the labeling processes for
the range of the x. Default is \code{13} (e.g., \eqn{\delta}^13 C).
This will create a column called \code{labels}, that will only be created when \code{data_format}
is set to \code{long}.}

\item{isotope_y}{a \code{numeric} that will be used in the labeling processes for
the range of the y isotope. Default is \code{15} (e.g., \eqn{\delta}^15 N).
#' This will create a column called \code{labels}, that will only be created when \code{data_format}
is set to \code{long}.}

\item{element_x}{a \code{character} that will be used in the labeling process for the range of the x
isotope. Default is \code{C} (e.g., \eqn{\delta}^13 C).
This will create a column called \code{labels}, that will only be created when \code{data_format}
is set to \code{long}.}

\item{element_y}{a \code{character} that will be used in the labeling process for the range of the y
isotope. Default is \code{N} (e.g., \eqn{\delta}^13 N).
#' This will create a column called \code{labels}, that will only be created when \code{data_format}
is set to \code{long}.}
}
\value{
A \code{tibble} containing four rows when \code{data_format} is set to its
default which is \code{long}. These four rows are the following, \code{community},
\code{the_name_of_the_communities}, \code{metric} and \code{post_est}.
}
\description{
Extract Bayesian estimates for the following six layman metrics,
\eqn{\delta^{13}}C range,  \eqn{\delta^{15}}N range, total area (TA),
distance to centroid (CD), distance to the nearest neighbour (NND), and
the standard deviation of the distance to the nearest neighbour (SDNND)
from data objects created by
\href{https://CRAN.R-project.org/package=SIBER}{{SIBER}}. To learn
more about the following metrics please review
\href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282007\%2988\%5B42\%3ACSIRPF\%5D2.0.CO\%3B2}{Layman et al. (2008)}.
}
\examples{

library(SIBER)

# ---- bring in SIBER demo data ----
# uncomenet to use
# str(demo.siber.data)

# ---- create community names data frame ----
# uncomment to use
# str(demo.siber.data.2)

demo.siber.data.2$group_name <- as.factor(demo.siber.data.2$group)

demo.siber.data.2$group <- as.numeric(demo.siber.data.2$group_name) |>
as.character()

demo.siber.data.2$community_names <- as.factor(demo.siber.data.2$community)

demo.siber.data.2$community <- as.numeric(demo.siber.data.2$community_names) |>
as.character()
c_names <- demo.siber.data.2 |>
dplyr::distinct(community, community_names)


demo.siber.data_2 <- demo.siber.data.2[,1:4]
# ---- create the siber object ----
siber.example <- createSiberObject(demo.siber.data_2)

# ---- view Bayesian estimates of mu and sigma produced by SIBER ---
# uncomment to use
# str(post_sam_siber)

# ---- extract posterior estimates of mu -----

mu_post <- extractPosteriorMeans(siber.example, post_sam_siber)

# ---- Bayesian estimates of layman metrics using SIBER ----

layman_b <- bayesianLayman(mu.post = mu_post)

# ---- use nichetools to extract Bayesian estimates of Layman metrics ----

layman_be <- extract_layman(layman_b, community_df = c_names)

layman_be

}
\seealso{
\code{\link[SIBER:bayesianLayman]{SIBER::bayesianLayman()}} and \code{\link[SIBER:createSiberObject]{SIBER::createSiberObject()}}
}
