% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_snap_counts.R
\name{load_snap_counts}
\alias{load_snap_counts}
\title{Load Snap Counts from PFR}
\usage{
load_snap_counts(
  seasons = most_recent_season(),
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{a numeric vector specifying what seasons to return, if \code{TRUE} returns all available data}

\item{file_type}{One of \code{c("rds", "qs", "csv", "parquet")}. Can also be set globally with
\code{options(nflreadr.prefer)}}
}
\value{
A tibble of game-level snap counts provided by Pro Football Reference.
}
\description{
Loads game level snap counts stats provided by Pro Football Reference
starting with the 2012 season.
}
\examples{
\dontshow{.for_cran()}
\donttest{
  try({ # prevents CRAN errors
  load_snap_counts()
  })
}

}
\seealso{
\url{https://nflreadr.nflverse.com/articles/dictionary_snap_counts.html} for the web data dictionary

\code{\link{dictionary_snap_counts}} for the data dictionary as bundled within the package

Issues with this data should be filed here: \url{https://github.com/nflverse/nflverse-pfr}
}
