% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dLd2.R
\name{dLd2}
\alias{dLd2}
\alias{ddLd2}
\alias{pdLd2}
\alias{qdLd2}
\alias{rdLd2}
\title{Discrete Lindley Distribution}
\usage{
ddLd2(x, theta, log = FALSE)

pdLd2(q, theta, lower.tail = TRUE, log.p = FALSE)

qdLd2(p, theta, lower.tail = TRUE)

rdLd2(n, theta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{a parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise, \eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{ddLd2} gives the density, \code{pdLd2} gives the distribution
function, \code{qdLd2} gives the quantile function and \code{rdLd2} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the discrete Lindley distribution.
}
\details{
the discrete Lindley distribution with a parameter \eqn{\theta},
has density
\deqn{f\left( x\right) =\frac{\lambda ^{x}}{1+\theta }
 \left( \theta \left(1-2\lambda \right) +\left( 1-\lambda \right)
 \left( 1+\theta x\right)\right),}
where
\deqn{x=0,1,2,...~,\lambda =\exp \left( -\theta \right) ~and~\theta >0.}
}
\examples{
library(new.dist)
ddLd2(2,theta=2)
pdLd2(1,theta=2)
qdLd2(.5,theta=2)
rdLd2(10,theta=1)
}
\references{
Bakouch, H. S., Jazi, M. A. ve Nadarajah, S., 2014,
\emph{A new discrete distribution, Statistics}, 48 (1), 200-240.
}
