% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample_images}
\alias{resample_images}
\title{Resample brain maps for comparison}
\usage{
resample_images(
  src,
  trg,
  src_space = c("fsaverage", "fsLR"),
  trg_space = c("fsaverage", "fsLR"),
  strategy = c("downsample_only", "transform_to_src", "transform_to_trg",
    "transform_to_alt"),
  alt_space = NULL,
  alt_density = NULL,
  hemisphere = c("left", "right"),
  area_surf_current = NULL,
  area_surf_new = NULL,
  wb_path = NULL,
  verbose = TRUE
)
}
\arguments{
\item{src}{Character, file path to the source GIFTI.}

\item{trg}{Character, file path to the target GIFTI.}

\item{src_space}{Source coordinate space (\code{"fsaverage"} or \code{"fsLR"}).}

\item{trg_space}{Target coordinate space (\code{"fsaverage"} or \code{"fsLR"}).}

\item{strategy}{Resampling strategy. One of \code{"downsample_only"},
\code{"transform_to_src"}, \code{"transform_to_trg"}, or \code{"transform_to_alt"}.}

\item{alt_space}{Alternative space for \code{"transform_to_alt"} strategy.}

\item{alt_density}{Alternative density for \code{"transform_to_alt"} strategy.}

\item{hemisphere}{Which hemispheres: \code{"left"}, \code{"right"}, or both.}

\item{area_surf_current}{Path to a current-resolution area-correction
surface (e.g. midthickness). Passed to \code{\link[=transform_to_space]{transform_to_space()}}.}

\item{area_surf_new}{Path to a target-resolution area-correction surface.
Passed to \code{\link[=transform_to_space]{transform_to_space()}}.}

\item{wb_path}{Path to \code{wb_command} executable.}

\item{verbose}{Logical, print progress messages.}
}
\value{
List with \verb{$src} and \verb{$trg} file paths in the aligned space.
}
\description{
Aligns two brain maps into the same coordinate space and density before
comparison. Supports multiple strategies for choosing the target space.
}
\examples{
\dontrun{
resample_images("src.func.gii", "trg.func.gii",
  src_space = "fsaverage", trg_space = "fsaverage"
)
}
}
\references{
Markello RD et al. (2022) Nature Methods 19:1472-1480.
doi:10.1038/s41592-022-01625-w
}
