% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/resample.R
\name{resample}
\alias{resample}
\alias{resample,NeuroVol,NeuroVol-method}
\alias{resample,NeuroVol,NeuroSpace-method}
\title{Resample an Image to Match the Space of Another Image}
\usage{
resample(source, target, ...)

\S4method{resample}{NeuroVol,NeuroVol}(source, target, interpolation = 3L)

\S4method{resample}{NeuroVol,NeuroSpace}(source, target, interpolation = 3L)
}
\arguments{
\item{source}{A NeuroVol object representing the source volume to be resampled.}

\item{target}{A NeuroSpace object representing the target space to match the dimensions and orientation of the source volume.}

\item{...}{Additional arguments passed to the resampling function, such as interpolation method, boundary handling, or other resampling options.}

\item{interpolation}{A single integer specifying the type of interpolation to be applied to the final resampled image. May be 0 (nearest neighbor), 1 (trilinear), or 3 (cubic spline). No other values are valid.}
}
\value{
An object representing the resampled \code{source} image, with the same spatial properties as \code{target}.
}
\description{
This function resamples a source image to match the spatial properties (dimensions, resolution, and orientation) of a target image.

This method resamples a NeuroVol object (\code{source}) to match the dimensions and orientation of a NeuroSpace object (\code{target}).
}
\examples{

img <- read_vol(system.file("extdata", "global_mask_v4.nii", package = "neuroim2"))
rspace <- space(img)


newtrans4X3 <- trans(img)[1:4, 1:3]
newtrans4X3 <- newtrans4X3 * c(.5,.5,.5,1)
newtrans <- cbind(newtrans4X3, c(space(img)@origin,1))

rspace <- NeuroSpace(rspace@dim*2, rspace@spacing/2, origin=rspace@origin, trans=trans(img))
\donttest{
rvol <- resample(img, rspace)
}


# Create source and target volumes
src_vol <- read_vol(system.file("extdata", "global_mask_v4.nii", package="neuroim2"))
targ_vol <- read_vol(system.file("extdata", "global_mask_v4.nii", package="neuroim2"))

# Resample source to match target
resampled <- resample(src_vol, targ_vol, interpolation=1)


}
\seealso{
\code{\link{NeuroVol}} for the base volume class
}
