% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R
\docType{class}
\name{NeuroSpace-class}
\alias{NeuroSpace-class}
\title{NeuroSpace Class}
\description{
The NeuroSpace class represents the geometric properties of a brain image,
including its dimensions, origin, spacing, axes, and coordinate transformations.
It provides a comprehensive framework for handling spatial information in
neuroimaging data analysis.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer vector representing the grid dimensions of the image.}

\item{\code{origin}}{A numeric vector representing the coordinates of the spatial origin.}

\item{\code{spacing}}{A numeric vector representing the dimensions (in mm) of the grid units (voxels).}

\item{\code{axes}}{A named \code{\linkS4class{AxisSet}} object representing the set of spatial axes in the untransformed native grid space.}

\item{\code{trans}}{A matrix representing an affine transformation that converts grid coordinates to real-world coordinates.}

\item{\code{inverse}}{A matrix representing an inverse transformation that converts real-world coordinates to grid coordinates.}
}}

\section{Validity}{

A \code{NeuroSpace} object is considered valid if:
\itemize{
  \item The length of the \code{dim} slot is equal to the lengths of the \code{spacing}, \code{origin}, and number of axes in the \code{axes} slots.
  \item The \code{dim} slot contains only non-negative values.
}
}

\section{Methods}{

The following methods are available for \code{NeuroSpace} objects:
\itemize{
  \item \code{\link{dim}}: Get the dimensions of the space.
  \item \code{\link{origin}}: Get or set the origin of the space.
  \item \code{\link{spacing}}: Get or set the spacing of the space.
  \item \code{\link{axes}}: Get the axes of the space.
  \item \code{\link{trans}}: Apply the affine transformation to coordinates.
}
}

\section{Usage}{

The \code{NeuroSpace} class is fundamental in representing and manipulating
the spatial properties of neuroimaging data. It is used extensively throughout
the package for operations that require spatial information, such as image
registration, resampling, and coordinate transformations.
}

\examples{
# Create a NeuroSpace object
space <- NeuroSpace(dim = c(64L, 64L, 64L),
                    origin = c(0, 0, 0),
                    spacing = c(1, 1, 1))

# Get the dimensions
dim(space)



}
\references{
For more information on spatial transformations in neuroimaging:
Brett, M., Johnsrude, I. S., & Owen, A. M. (2002). The problem of functional localization in the human brain. Nature Reviews Neuroscience, 3(3), 243-249.
}
\seealso{
\code{\link{AxisSet-class}} for details on the axis set representation.
\code{\link{NeuroVol-class}} and \code{\link{NeuroVec-class}} for classes that use NeuroSpace.
}
