% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_class.R
\docType{class}
\name{FileMetaInfo-class}
\alias{FileMetaInfo-class}
\alias{NIFTIMetaInfo-class}
\alias{AFNIMetaInfo-class}
\title{FileMetaInfo Class}
\description{
This class extends MetaInfo to include file-specific metadata for neuroimaging data files.

This class extends FileMetaInfo with NIfTI-specific metadata.

This class extends FileMetaInfo with AFNI-specific metadata.
}
\section{Slots}{

\describe{
\item{\code{header_file}}{A \code{character} string specifying the name of the file containing meta information.}

\item{\code{data_file}}{A \code{character} string specifying the name of the file containing image data.}

\item{\code{descriptor}}{A \code{\linkS4class{FileFormat}} object describing the image file format.}

\item{\code{endian}}{A \code{character} string specifying the byte order of data ('little' or 'big').}

\item{\code{data_offset}}{A \code{numeric} value indicating the number of bytes preceding the start of image data in the data file.}

\item{\code{bytes_per_element}}{An \code{integer} specifying the number of bytes per data element.}

\item{\code{intercept}}{A \code{numeric} vector of constant values added to image data (one per sub-image).}

\item{\code{slope}}{A \code{numeric} vector of multipliers for image data (one per sub-image).}

\item{\code{header}}{A \code{list} of format-specific attributes.}

\item{\code{nifti_header}}{A \code{list} of attributes specific to the NIfTI file format.}

\item{\code{afni_header}}{A \code{list} of attributes specific to the AFNI file format.}
}}

\seealso{
\code{\link{MetaInfo-class}}, \code{\link{NIFTIMetaInfo-class}}, \code{\link{AFNIMetaInfo-class}}

\code{\link{FileMetaInfo-class}}

\code{\link{FileMetaInfo-class}}
}
