% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuroSCC-package.R
\docType{package}
\name{neuroSCC-package}
\alias{neuroSCC-package}
\alias{neuroSCC}
\title{Wrappers for Neuroimaging Functional Data Preparation and SCC Analysis}
\description{
The \code{neuroSCC} package provides tools to preprocess and structure neuroimaging data
for functional data analysis using Simultaneous Confidence Corridors (SCCs). It wraps external packages
to prepare data from PET images, extract contours, generate meshes, and evaluate regions of statistical significance.

The methods implemented support both group comparisons and single-subject vs. group inference,
following the methodology described in Wang et al. (2020) and the author's PhD thesis.
}
\details{
This package serves as a bridge between neuroimaging file formats (e.g., NIfTI) and advanced
statistical tools like \code{ImageSCC::scc.image}. It includes the following key components.
\itemize{
  \item Loading and cleaning PET image data.
  \item Extracting ROIs and constructing functional data matrices.
  \item Generating synthetic Poisson clones for 1-vs-group settings.
  \item Extracting SCC-detected points and evaluating detection metrics.
}
}
\seealso{
\code{\link{neuroCleaner}}, \code{\link{databaseCreator}}, \code{\link{getPoints}}
}
\author{
\strong{Maintainer}: Juan A. Arias Lopez \email{juanantonio.arias.lopez@usc.es} (\href{https://orcid.org/0000-0002-3355-6393}{ORCID}) [copyright holder]

Other contributors:
\itemize{
  \item Virgilio Gomez Rubio \email{Virgilio.Gomez@uclm.es} (\href{https://orcid.org/0000-0002-4791-3072}{ORCID}) [reviewer]
  \item Pablo Aguiar Fernandez \email{pablo.aguiar@usc.es} (\href{https://orcid.org/0000-0002-7322-2195}{ORCID}) [thesis advisor]
  \item Andrew Haddon Kemp \email{A.H.Kemp@swansea.ac.uk} (\href{https://orcid.org/0000-0003-1146-3791}{ORCID}) [thesis advisor]
}

}
