% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparetree.R
\name{comparetree}
\alias{comparetree}
\title{comparetree}
\usage{
comparetree(
  tree,
  id1 = 2L,
  id2 = 3L,
  transform = "detect",
  highlights = 5,
  plot = FALSE,
  plot.type = c("compare", "subtract"),
  layout = "constrained",
  ...
)
}
\arguments{
\item{tree}{a networktree object}

\item{id1}{the first partition}

\item{id2}{the second partition}

\item{transform}{should stored correlation matrices be transformed to partial correlations 
or graphical lasso? Can be set to "cor", "pcor", or "glasso". Defaults to automatic detection}

\item{highlights}{the number of comparisons to highlight}

\item{plot}{plot a comparison of the two partitions?}

\item{plot.type}{"compare" or "subtract". "compare" plots the two networks
side by side. "subtract" subtracts network 2 from network 1, and plots
a network where edge weights indicate the difference}

\item{layout}{layout for the plots. The default "constrained" uses a
FR layout from the full dataset}

\item{...}{additional arguments passed to qgraph}
}
\description{
Quickly compares two partitions of a networktree object
}
\examples{
set.seed(1)
d <- data.frame(trend = 1:200, foo = runif(200, -1, 1))
d <- cbind(d, rbind(
  mvtnorm::rmvnorm(100, mean = c(0, 0, 0),
          sigma = matrix(c(1, 0.5, 0.5, 0.5, 1, 0.5, 0.5, 0.5, 1), ncol = 3)),
  mvtnorm::rmvnorm(100, mean = c(0, 0, 0),
          sigma = matrix(c(1, 0, 0.5, 0, 1, 0.5, 0.5, 0.5, 1), ncol = 3))
))
colnames(d)[3:5] <- paste0("y", 1:3)

## Generate a networktree
tree1 <- networktree(nodevars=d[,3:5], splitvars=d[,1:2])

## Print out the structure
tree1

## Compare any two partitions
comparetree(tree1, id1=2, id2=3, highlights=3)

## Add a comparison plot
comparetree(tree1, id1=2, id2=3, plot=TRUE)

}
