% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-auth.R
\name{ns_has_auth}
\alias{ns_has_auth}
\title{Check Environment Variables for Nettskjema Authentication}
\usage{
ns_has_auth(
  client_id = Sys.getenv("NETTSKJEMA_CLIENT_ID"),
  client_secret = Sys.getenv("NETTSKJEMA_CLIENT_SECRET")
)
}
\arguments{
\item{client_id}{[character] The client ID provided by Nettskjema.}

\item{client_secret}{[character] The client secret provided
by Nettskjema.}
}
\value{
Logical. Returns `TRUE` if both environment
   variables are set, otherwise `FALSE`.
}
\description{
This function verifies whether the required system
variables (`NETTSKJEMA_CLIENT_ID` and
`NETTSKJEMA_CLIENT_SECRET`) are set to enable
authentication with the Nettskjema API. It provides
feedback on the setup status and returns whether the
system is correctly configured.
}
\examples{
ns_has_auth()

}
\references{
For more information about authentication setup, see:
https://www.capro.dev/nettskjemar/articles/authentication.html
}
