% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_triad_var.R
\name{get_triad_var}
\alias{get_triad_var}
\title{Get Triad Variables}
\usage{
get_triad_var(var, type = "att")
}
\arguments{
\item{var}{variable vector (actor attribute) or adjacency matrix (ties)
to be transformed to a triad variable.}

\item{type}{either 'att' for actor attribute (default) or 'tie' for relations.}
}
\value{
Dataframe with four columns:
first three columns show the vertex triad \code{u}, \code{v}, \code{w} ,
and the fourth column gives the value of the transformed triadic variable \code{var}.
}
\description{
Transforms vertex variables or observed directed/undirected ties
into triad variables.
}
\details{
For actor attributes, unique triples of original attribute values
constitute the outcome space. Note that the actor
attributes need to be categorical with finite range spaces.
For example, binary attributes have 8 possible triadic outcomes
(0,0,0),(1,0,0),(0,1,0),(1,1,0),(0,0,1),(1,0,1),(0,1,1),(1,1,1)
which are coded 0-7.
Warning message is shown if actor attribute has too many unique outcomes
as it will yield too many possible outcomes once converted in to a triad variable.
\cr

For directed relations, a sequence of indicators of length 6 created from the adjacency matrix
constitutes the 64 outcomes representing possible combinations of sending and receiving ties.
\cr

For undirected relations, triples of indicators are created from the adjacency matrix.
\cr
}
\examples{
# use internal data set
data(lawdata)
adj.advice <- lawdata[[1]]
adj.cowork <- lawdata[[3]]
df.att <- lawdata[[4]]

# three steps of data editing:
# 1. categorize variables 'years' and 'age' based on
# approximately three equally size groups (values based on cdf)
# 2. make sure all outcomes start from the value 0 (optional)
# 3. remove variable 'senior' as it consists of only unique values (thus redundant)
df.att.ed <- data.frame(
    status = df.att$status,
    gender = df.att$gender,
    office = df.att$office - 1,
    years = ifelse(df.att$years <= 3, 0,
        ifelse(df.att$years <= 13, 1, 2)
    ),
    age = ifelse(df.att$age <= 35, 0,
        ifelse(df.att$age <= 45, 1, 2)
    ),
    practice = df.att$practice,
    lawschool = df.att$lawschool - 1
)

# actor attribute converted to triad variable
triad.gend <- get_triad_var(df.att.ed$gender, "att")

# directed tie converted to triad variable
triad.adv <- get_triad_var(adj.advice, type = "tie")

# undirected tie converted to triad variable
triad.cwk <- get_triad_var(adj.cowork, type = "tie")
}
\references{
Frank, O., & Shafie, T. (2016). Multivariate entropy analysis of network data.
\emph{Bulletin of Sociological Methodology/Bulletin de Méthodologie Sociologique}, 129(1), 45-63.
}
\seealso{
\code{\link{get_dyad_var}}
}
\author{
Termeh Shafie
}
