% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netSEMp1.R
\name{netSEMp1}
\alias{netSEMp1}
\title{network Structural Equation Modeling (netSEM)}
\usage{
netSEMp1(x, exogenous, endogenous)
}
\arguments{
\item{x}{A dataframe. By default it considers all columns as exogenous variables, except the first column which stores the system's endogenous variable.}

\item{exogenous, }{by default it considers all columns as exogenous variables except column number 1, which is the main endogenous response.}

\item{endogenous}{A character string of the column name of the main endogenous OR a numeric number indexing the column of the main endogenous.}
}
\value{
An object of class netSEM, which is a list of the following items:

\itemize{
\item "data": data frame used in netSEMp1 analysis.
\item "exogenous": Main stressor variable.
\item "endogenous": Main response variable.
\item "bestModels": A dataframe.
\item "allModels": A list of model objects.
}
}
\description{
This function carries out netSEM using markovian principle.
}
\details{
netSEMp1 determines the univariate relationships in the spirit of the Markovian process and builds a network model. In this case, the relationship between each pair of system variables, including predictors and the system level response is determined with the Markovian property that assumes the value of the current predictor is sufficient in relating to the next level variable, i.e., the relationship is independent of the specific value of the preceding-level variable to the current predictor, given the current value.
Each pair of variables is tested for sensible (in the domain knowledge sense) paring relation chosen from pre-selected common functional forms in linear regression settings.
Adjusted R-squared is used for model selection for every pair.

P-values reported in the "res.print" field of the return list contains the P-values of estimators of linear regression coefficients.
The P-values are ordered in the common order of coefficients, i.e. in the order of increasing exponents.
For example, in the quadratic functional form \eqn{y \sim b_0 + b_1 x + b_2 x^2}, the three P-values correspond to those of \eqn{\hat{b}_0}, \eqn{\hat{b}_1} and \eqn{\hat{b}_2}, respectively.
If there are less than 3 coefficients to estimate, the extra P-value field is filled with NA's.
}
\examples{
\dontrun{
## Load the sample acrylic data set
data(acrylic)

## Run netSEM_markovian
ans <- netSEMp1(acrylic, "IrradTot", "YI")
}
}
