% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseBlockRow.R
\name{chooseBlockRow}
\alias{chooseBlockRow}
\title{Sum of squared error across blocks}
\usage{
chooseBlockRow(X, actor, partition, M, loops, randomBlock = FALSE)
}
\arguments{
\item{X}{Binary network; of class \code{matrix}.}

\item{actor}{A unit (actor; row/column number), which have an opportunity to change a link.}

\item{partition}{A partition in a vector format. Each unique value (positive integers) represents one cluster.}

\item{M}{Image matrix with block densities.}

\item{loops}{Wheter loops are allowed or not.}

\item{randomBlock}{How to select a block; the one with the highest difference (\code{FALSE}, default), proportionally to the differences (\code{linear}) or squared differences (\code{square}).}
}
\value{
A vector with two elements: \code{block} (selected block number) and \code{sign} (wheter the selected block is too sparse (-1) or too dense (+1)).
}
\description{
The actor choose the block (i.e., column in an image matrix) in which he will change a link, based on the difference between the density of his out-degrees by blocks and the ideal block density.
}
\examples{
X <- matrix(sample(c(0,1), size = 9**2, replace = TRUE), nrow = 9)
diag(X) <- 0
M <- matrix(c(0.1, 0.4, 0.5, 0.3), nrow = 2)
partition <- c(1, 2, 2, 1, 1, 2, 2, 2, 1)
chooseBlockRow(X = X, actor = 3, partition = partition, 
M = M, loops = FALSE, randomBlock = "square")
}
\author{
Marjan Cugmas
}
