% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusECDF.R
\name{consensusECDF}
\alias{consensusECDF}
\title{Consensus Matrix ECDFs}
\usage{
consensusECDF(neatmap_res)
}
\arguments{
\item{neatmap_res}{Output from the \code{\link{neatmap}} function.}
}
\value{
Returns a ggplot depicting the ECDFs of each iteration of the
consensus clustering, i.e. one ECDF per number of clusters used in each
iteration.
}
\description{
\code{consensusECDF} plots the empirical cumulative distribution functions
(ECDF) of the consensus matrices produced during the consensus clustering
step of the \code{\link{neatmap}} function.
}
\details{
This function visualizes the ECDFs of the consensus matrices for each each 
iteration of consensus clustering that is carried out as part of the 
\code{\link{neatmap}} function.
}
\examples{
#' # create the data frame using the network, node and edge attributes
df <- netsDataFrame(network_attr_df,
                    node_attr_df,
                    edge_df)

# run the neatmap code on df
neat_res <- neatmap(df, scale_df = "ecdf", max_k = 3, reps = 100, 
                    xlab = "vars", ylab = "nets", xlab_cex = 1, ylab_cex = 1)
                    
# create the ECDF plot
consensusECDF(neat_res)
}
\references{
For more information on the consensus matrices, see
\href{https://link.springer.com/article/10.1023\%2FA\%3A1023949509487}{Monti et al.}.
}
\author{
Philippe Boileau , \email{philippe_boileau@berkeley.edu}
}
