test_that("nday works correctly", {
  today <- Sys.Date()
  expect_match(nday(today, show_relative_day = TRUE), "Today,")
  expect_equal(
    nday(as.Date("2022-01-01"), show_relative_day = TRUE),
    "Sat"
  )
  expect_match(nday(today - 1, show_relative_day = TRUE), "Yesterday,")
  expect_match(nday(today + 1, show_relative_day = TRUE), "Tomorrow,")
  expect_error(nday("2023-01-01"))
})

test_that("ndate works correctly", {
  d <- as.Date("2023-01-01")
  expect_match(ndate(d, show_weekday = FALSE), "Jan 01, 2023")
  expect_match(ndate(d, show_month_year = TRUE), "Jan'23")
})

test_that("ntimestamp works correctly", {
  ts <- as.POSIXct("2023-01-01 12:30:45", tz = "UTC")
  expect_match(
    ntimestamp(ts, show_weekday = FALSE),
    "Jan 01, 2023 12H 30M 45S PM UTC"
  )
  expect_match(ntimestamp(ts,
                 show_seconds = FALSE,
                 show_weekday = FALSE
               ), "Jan 01, 2023 12H 30M PM UTC")
})
