% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{geom_ncdf}
\alias{geom_ncdf}
\title{Create a plot object for a \code{CFVariable}}
\usage{
geom_ncdf(mapping = NULL, data, ...)
}
\arguments{
\item{mapping}{As in \link[ggplot2:geom_tile]{geom_raster}. If the argument
is not provided, a mapping is constructed from the properties of the \code{data}
argument, which is usually the right way.}

\item{data}{A \link{CFVariable} instance. This will override any \code{data} setting of
the \code{ggplot()} function.}

\item{...}{Arguments passed on to \code{geom_raster()}.}
}
\value{
A \verb{geom_*} object that can be used in \code{ggplot2} plot composition.
}
\description{
This is a basic function to support plotting of \code{ncdfCF} data
with the \code{ggplot2} package. Specifically, this function creates a \code{geo_ncdf}
object which can be used like a \code{geom_raster}. The \code{geom_ncdf} takes a
\code{CFVariable} instance as its \code{data}. The \code{CFVariable} should be properly
pre-processed to make it suitable for plotting. The \verb{$subset()} method is
well suited for this task. Note that currently only map plotting works, e.g.
the \code{CFVariable} should have \code{X} and \code{Y} axes.
}
\examples{
library(ggplot2)
fn <- system.file("extdata", "tasmax_NAM-44_day_20410701-vncdfCF.nc", package = "ncdfCF")
ds <- open_ncdf(fn)
tasmax <- ds[["tasmax"]]
ggplot() + geom_ncdf(data = tasmax) + coord_equal() + scale_fill_viridis_c()
}
