% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_stats.R
\name{group_stats}
\alias{group_stats}
\title{Aggregate player statistics and play-by-play information}
\usage{
group_stats(
  teams = NULL,
  year = NULL,
  level = "teamseason",
  unique = TRUE,
  sport = "WVB"
)
}
\arguments{
\item{teams}{Character vector of team names to aggregate.}

\item{year}{Numeric vector of years for fall of desired seasons.}

\item{level}{Character string defining whether to aggregate "teamseason",
"teammatch", "playermatch", or match play-by-play ("pbp") data.}

\item{unique}{Logical indicating whether to only process unique contests
(TRUE) or whether to process duplicated contests (FALSE). Default is TRUE.}

\item{sport}{Three letter abbreviation for NCAA sport (must be upper case;
for example "WVB" for women's volleyball and "MVB" for men's volleyball).}
}
\value{
For season level, returns list with data frames of player statistics and
team statistics. For match and pbp levels, returns data frame of player
statistics and play-by-play information respectively.
}
\description{
This function aggregates player statistics and play-by-play information
within a season by applying \code{\link[=team_match_stats]{team_match_stats()}}, \code{\link[=player_season_stats]{player_season_stats()}}, \code{\link[=player_match_stats]{player_match_stats()}},
or \code{\link[=match_pbp]{match_pbp()}} across groups of teams (for \code{\link[=player_season_stats]{player_season_stats()}}) or
across contests within a season (for \code{\link[=team_match_stats]{team_match_stats()}},
\code{\link[=player_match_stats]{player_match_stats()}} and \code{\link[=match_pbp]{match_pbp()}}).
For season stats, it aggregates all player data and team
data into separate data frames and combines them into a list.
For instance, if you want to extract the data from the teams in the women's
2024 Final Four, pass a vector of
\code{c("Louisville", "Nebraska", "Penn State", "Pittsburgh")}
to the function. For match or play-by-play data for a team, pass a single
team name and year. Team names can be found in \link{ncaa_teams} or by
using \code{\link[=find_team_name]{find_team_name()}}.
}
\note{
This function \strong{requires internet connectivity} as it checks the
\href{https://stats.ncaa.org}{NCAA website} for information.
It also uses the \href{https://rstudio.github.io/chromote/}{\code{{chromote}}} package
and \strong{requires \href{https://www.google.com/chrome/}{Google Chrome}} to be
installed.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
group_stats(teams = c("Louisville", "Nebraska", "Penn St.", "Pittsburgh"),
year = 2024, level = "teamseason")
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions that aggregate statistics: 
\code{\link{conference_stats}()},
\code{\link{division_stats}()}
}
\concept{functions that aggregate statistics}
