% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InferenceFunctions.R
\name{make.pmatrix}
\alias{make.pmatrix}
\title{Make matrix of treatment assignment probabilities}
\usage{
make.pmatrix(Z, X)
}
\arguments{
\item{Z}{an N-length vector of treatment values, which must be numeric.}

\item{X}{an N x k matrix of covariate values, which must be numeric.}
}
\value{
an N x N numeric matrix. Each entry represents the probability the
ith observation has Z = max(Z_i, Z_j) and the jth observation has
Z = min(Z_i, Z_j), conditioned on covariates.
}
\description{
This function creates a N x N matrix where the diagonals equal zero, and the
off-diagonal elements (i, j) contain the probability the ith observation has
Z = max(Z_i, Z_j) and the jth observation has Z = min(Z_i, Z_j), conditioned
on covariates. Uses the "model-based" conditional density estimation method
described in \insertCite{frazier2024bias}{nbpInference}.
}
\examples{
set.seed(12345)
X <- rnorm(100, 0, 5)
Z <- X + rnorm(100, 0, (1+sqrt(abs(X))))
make.pmatrix(Z, X)
}
\seealso{
Other inference: 
\code{\link{bias.corrected.neyman}()},
\code{\link{classic.neyman}()},
\code{\link{covAdj.variance}()},
\code{\link{nbp.caliper}()}
}
\concept{inference}
