% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InferenceFunctions.R
\name{covAdj.variance}
\alias{covAdj.variance}
\title{Covariate-Adjusted Variance Estimation}
\usage{
covAdj.variance(Y, Z, X, pairs, pmat, xi, Q)
}
\arguments{
\item{Y}{a 2I-length vector of outcome values}

\item{Z}{a 2I-length vector of treatment values}

\item{X}{a 2I x k matrix of covariate values}

\item{pairs}{an I x 2 dataframe containing the indices of observations
that form our set of matched pairs. An appropriate pairs dataframe can be
formed using the \link[nbpInference]{nbp.caliper} function.}

\item{pmat}{a 2I x 2I matrix where the diagonals equal zero, and the
off-diagonal elements (i, j) contain the probability the ith observation has
Z = max(Z_i, Z_j) and the jth observation has Z = min(Z_i, Z_j). We can create
a p-matrix using the make.pmatrix function. A p-matrix can be created using
the \link[nbpInference]{make.pmatrix} function.}

\item{xi}{a number in the range 0 to 0.5, the cutoff related to the treatment
assignment probability caliper.}

\item{Q}{an arbitrary I x L numeric (real-valued) matrix, where L < I}
}
\value{
a 2I x 2I numeric matrix
}
\description{
This function calculates the covariate-adjusted conservative variance estimator
For the (classic or bias-corrected) Neyman estimator. For details on the
definition of the covariate-adjusted Neyman estimator, see \insertCite{fogarty2018mitigating;textual}{nbpInference}
and \insertCite{frazier2024bias;textual}{nbpInference}.
}
\examples{
set.seed(12345)
X <- rnorm(100, 0, 5)
Z <- X + rnorm(100, 0, (1+sqrt(abs(X))))
Y <- X + Z + rnorm(100, 0, 0.5)
pmat <- make.pmatrix(Z, X)
pairs <- nbp.caliper(Z, X, pmat, xi = 0.1, M = 10000)
covAdj.variance(Y, Z, X, pairs, pmat, xi = 0.1)
}
\seealso{
Other inference: 
\code{\link{bias.corrected.neyman}()},
\code{\link{classic.neyman}()},
\code{\link{make.pmatrix}()},
\code{\link{nbp.caliper}()}
}
\concept{inference}
