% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{nba_palette}
\alias{nba_palette}
\title{An NBA  palette generator}
\usage{
nba_palette(name, n, type = c("discrete", "continuous"))
}
\arguments{
\item{name}{Name of desired palette. use `available_palettes()` to see which
options are available}

\item{n}{Number of colors desired. Most palettes contain 3-5 colors although
some contain as many as 8-10.  All color schemes are derived from the
following amazing resource:
  \href{https://www.trucolor.net/portfolio/national-basketball-association-franchise-records-1946-1947-through-present/}{TruColor}.
  If omitted, uses all colours.}

\item{type}{Either "continuous" or "discrete". Use continuous if you want
to automatically interpolate between colours.}
}
\value{
A vector of colours.
}
\description{
Color palettes associated with a large variety of NBA team jerseys.
}
\examples{
nba_palette("raptors")
nba_palette("jazz_city")
nba_palette("nuggets_80s")

# If you need more colours than normally found in a palette, you
# can use a continuous palette to interpolate between existing
# colours
pal <- nba_palette(n = 21, name = "grizzlies", type = "continuous")
pal
}
\keyword{colors}
