% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/natstrat-package.R
\docType{package}
\name{natstrat-package}
\alias{natstrat}
\alias{natstrat-package}
\title{natstrat: Obtain Unweighted Natural Strata that Balance Many Covariates}
\description{
Natural strata can be used in observational studies to balance
the distributions of many covariates across any number of treatment
groups and any number of comparisons. These strata have proportional
amounts of units within each stratum across the treatments, allowing
for simple interpretation and aggregation across strata. Within each
stratum, the units are chosen using randomized rounding of a linear
program that balances many covariates. For more details, see Brumberg et al. (2022) <doi:10.1111/rssa.12848> and Brumberg et al.(2023) <doi:10.1093/jrsssc/qlad010>.
To solve the linear program, the 'Gurobi' commercial optimization software
is recommended, but not required. The 'gurobi' R package can be installed by following the instructions
\href{https://docs.gurobi.com/projects/optimizer/en/current/reference/r/setup.html}{here} after claiming your free academic license 
\href{https://www.gurobi.com/academia/academic-program-and-licenses/}{here}.
}
\details{
To achieve the desired ratio of control to treated units,
a subset of control units are
chosen using by optimizing the balance of many covariates using
either randomized rounding of a linear program or
an integer program. The main function in this package is \code{\link{optimize_controls}()}.
To create the input constraints for this function, you should use
\code{\link{generate_constraints}()}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/kkbrum/natstrat}
  \item \url{https://kkbrum.github.io/natstrat/}
  \item \url{https://docs.gurobi.com/projects/optimizer/en/current/reference/r/setup.html}
  \item Report bugs at \url{https://github.com/kkbrum/natstrat/issues}
}

}
\author{
\strong{Maintainer}: Katherine Brumberg \email{kbrum@umich.edu}

}
\keyword{internal}
