% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/im3d.R
\name{mask}
\alias{mask}
\alias{mask.im3d}
\title{Mask an object, typically to produce a copy with some values zeroed out}
\usage{
mask(x, ...)

\method{mask}{im3d}(x, mask, levels = NULL, rval = c("im3d", "values"), invert = FALSE, ...)
}
\arguments{
\item{x}{Object to be masked}

\item{\dots}{Additional arguments passed to methods}

\item{mask}{An im3d object, an array or a vector with dimensions compatible 
with x.}

\item{levels}{Optional numeric vector of pixel values or character vector 
defining named \code{\link{materials}}.}

\item{rval}{Whether to return an im3d object based on \code{x} or just the 
values from \code{x} matching the mask.}

\item{invert}{Whether to invert the voxel selection (default \code{FALSE})}
}
\value{
an oject with attributes matching \code{x} and elements with value 
  \code{as.vector(TRUE, mode=mode)} i.e. \code{TRUE, 1, 0x01} and 
  \code{as.vector(FALSE, mode=mode)} i.e. \code{FALSE, 0, 0x00} as 
  appropriate.

A copy of x with
}
\description{
Mask an object, typically to produce a copy with some values zeroed out
}
\details{
Note that \code{mask.im3d} passes \dots arguments on to im3d
}
\examples{
x=im3d(array(rnorm(1000),dim=c(10,10,10)), BoundingBox=c(20,200,100,200,200,300))
m=array(1:5,dim=c(10,10,10))
image(x[,,1])
image(mask(x, mask=m, levels=1)[,,1])
image(mask(x, mask=m, levels=1:2)[,,1])
}
\seealso{
Other im3d: 
\code{\link{as.im3d}()},
\code{\link{boundingbox}()},
\code{\link{im3d}()},
\code{\link{im3d-coords}},
\code{\link{im3d-io}},
\code{\link{imexpand.grid}()},
\code{\link{imslice}()},
\code{\link{is.im3d}()},
\code{\link{origin}()},
\code{\link{projection}()},
\code{\link{threshold}()},
\code{\link{unmask}()},
\code{\link{voxdims}()}
}
\concept{im3d}
