% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiclass_learners.R
\name{multiclass_learners}
\alias{multiclass_learners}
\title{Multiclass Learners in \code{\{nadir\}}}
\description{
\itemize{
\item \code{lnr_multinomial_nnet}
\item \code{lnr_multinomial_vglm}
}
}
\details{
Suppose one of these is trained on some data and the fit learner is stored.
Suppose we are going to call it on \code{newdata} and \code{newdata$class} is
the outcome variable being predicting.

The important thing to know about multiclass learners is that they
produce predictions that the outcome class is equal to
\code{newdata$class} given the covariates specified in
\code{newdata}.

Similar to density estimation, we want to use
\code{determine_weights_using_neg_log_loss} in our calls to
\code{super_learner()}. This can be done automatically by declaring \code{outcome_type = 'multiclass'}
in calling \code{super_learner()}
}
\examples{
  super_learner(
    data = iris,
    learners = list(lnr_multinomial_vglm, lnr_multinomial_vglm, lnr_multinomial_nnet),
    formulas = list(
    .default = Species ~ .,
    multinomial_vglm2 = Species ~ Petal.Length*Petal.Width + .),
    outcome_type = 'multiclass'
    )

}
\seealso{
density_learners binary_learners learners
}
\keyword{multiclass_learners}
