% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{check_simple_lhs}
\alias{check_simple_lhs}
\title{Validate that a formula has a simple left-hand side}
\usage{
check_simple_lhs(formula)
}
\arguments{
\item{formula}{A formula to be checked to ensure its left-hand-side (dependent/outcome) variable
is not complex.}
}
\value{
Invisibly TRUE if okay; otherwise errors.
}
\description{
For example, a complex left-hand-side would be one that includes a transformation
like \code{log(y) ~ x1 + x2} or as is commonly done in survival modeling, a
survival outcome as in \code{Surv(time, death) ~ x1 + x2}.  Both of these
examples are considered "complex" left-hand-sides by \code{nadir} and are not
currently supported.  This function simply checks that the left-hand-side is
simple (as in, not complex), and returns \code{TRUE} in that case. An error is thrown
if the left-hand-side is complex. is not the case.
}
\keyword{internal}
