% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute-constant.R, R/na.constant.R, R/na.inf.R,
%   R/na.true.R, R/na.zero.R
\name{impute-constant}
\alias{impute-constant}
\alias{na.constant}
\alias{na.inf}
\alias{na.neginf}
\alias{na.true}
\alias{na.false}
\alias{na.zero}
\title{Impute by Constant Value

Replaces \code{NA}s by a constant}
\usage{
na.constant(.x, .na)

na.inf(.x)

na.neginf(.x)

na.true(.x)

na.false(.x)

na.zero(.x)
}
\arguments{
\item{.x}{vector; of values to have the \code{NA}}

\item{.na}{scalar to use as replacement.}
}
\value{
A vector with the type and length of \code{x} with all missing values replaces
by \code{.na}.
}
\description{
Impute by Constant Value

Replaces \code{NA}s by a constant
}
\details{
These functions replace \strong{ALL} \code{NA} values in \code{x} with an scalar
value specified by\code{.na}.

\code{na.constant} replaces missing values with a scalar constant. It is a wrapper
around \code{\link[=na.replace]{na.replace()}} but permits \code{.na} to only be a scalar.

\code{na.inf} and \code{na.neginf} replace all missing values with \code{Inf} and \code{-Inf}
repectively.  `.

\code{na.true} and \code{na.false} replace missing values with \code{TRUE} and \code{FALSE}
respectively.

\code{na.zero} replaces missing values with \code{0} which gets coerced to the
\code{class(x)} as needed.
}
\examples{
  na.constant( c(1,NA,2), -1 )
 
  na.inf( c( 1, 2, NA, 4) )
  na.neginf( c( 1, 2, NA, 4) ) 
  
  na.true( c(TRUE, NA_logical, FALSE) )   # T T F
  na.false( c(TRUE, NA_logical, FALSE) )  # T F F

 
           
  na.zero( c(1,NA,3) )  # 1 0 3 

 
           
}
\seealso{
\itemize{
\item \code{\link[=na.replace]{na.replace()}} the underlying function that performs the replacement.
}
}
