% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_values.R
\name{compare_values}
\alias{compare_values}
\title{Function to compare values of matched data frames.}
\usage{
compare_values(
  dfx = NULL,
  dfy = NULL,
  myrror_object = NULL,
  by = NULL,
  by.x = NULL,
  by.y = NULL,
  output = c("full", "simple", "silent"),
  interactive = getOption("myrror.interactive"),
  verbose = getOption("myrror.verbose"),
  tolerance = getOption("myrror.tolerance")
)
}
\arguments{
\item{dfx}{a non-empty data.frame.}

\item{dfy}{a non-empty data.frame.}

\item{myrror_object}{myrror object from \link{create_myrror_object}}

\item{by}{character, key to be used for dfx and dfy.}

\item{by.x}{character, key to be used for dfx.}

\item{by.y}{character, key to be used for dfy.}

\item{output}{character: one of "full" (returns a myrror_object), "simple" (returns a dataframe), "silent" (invisible object returned).}

\item{interactive}{logical: If \code{TRUE}, print S3 method for myrror objects
displays by chunks. If \code{FALSE}, everything will be printed at once.}

\item{verbose}{logical: If \code{TRUE} additional information will be displayed.}

\item{tolerance}{numeric, default to 1e-7.}
}
\value{
Depending on \code{output} parameter:
\itemize{
\item \code{"full"}: myrror object with \code{compare_values} slot containing a summary tibble of value differences
\item \code{"simple"}: tibble with columns: variable, change_in_value, na_to_value, value_to_na (counts)
\item \code{"silent"}: invisibly returns myrror object (same as "full")
}
Returns \code{NULL} if no differences are found and \code{output = "simple"}.
}
\description{
Function to compare values of matched data frames.
}
\examples{

# 1. Standard report, myrror_object output:
compare_values(survey_data, survey_data_2, by=c('country', 'year'))

# 2. Simple output, list of data.tables output:
compare_values(survey_data, survey_data_2, by=c('country', 'year'),
               output = 'simple')

# 3. Toggle tolerance:
compare_values(survey_data, survey_data_2, by=c('country', 'year'),
               tolerance = 1e-5)

# 4. Toggle interactvity:
compare_values(survey_data, survey_data_2, by=c('country', 'year'),
               interactive = FALSE)

# 5. Different keys (see also ?myrror):
compare_values(survey_data, survey_data_2_cap,
               by.x = c('country', 'year'), by.y = c('COUNTRY', 'YEAR'))

# 6. Using existing myrror object created by myrror():
myrror(survey_data, survey_data_2, by=c('country', 'year'))
compare_values()

}
