% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{southeast_alaska_wolf}
\alias{southeast_alaska_wolf}
\title{Wolf environmental DNA in southeast Alaska}
\usage{
data(southeast_alaska_wolf)
}
\value{
A data long-form data frame
}
\description{
Data to demonstrate multivariate Tweedie GAM for spatial analysis
}
\details{
Data sufficient to demonstrate how to use a Tweedie GLM to provide inference
about proportions e.g. in food habits analysis, where the model output is
processed to represent a multivariate logit Tweedie model.

Specifically includes environmental DNA sampling of wolf scats obtained in Southeast Alaska.

\itemize{
\item \code{Latitude} Latitude for scat sample
\item \code{Longitude} Longitude for scat sample
\item \code{group} prey groupings from eDNA smaples
\item \code{Response} relative read abundance calculated as the mean
proportion of DNA sequence reads from each species among samples
from a given scat
}
}
\references{
Roffler, G. H., J. M. Allen, A. Massey, and T. Levi. 2021.
Wolf Dietary Diversity in an Island Archipelago. Bulletin of
the Ecological Society of America 102: 1-6.
\doi{10.1002/bes2.1834}
}
\author{
Gretchen Roffler
}
\keyword{data}
