% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvtsplot.R
\name{mvtsplot}
\alias{mvtsplot}
\title{Plot Multivariate Time Series Data}
\usage{
mvtsplot(
  x,
  group = NULL,
  xtime = NULL,
  norm = c("internal", "global"),
  levels = 3,
  smooth.df = NULL,
  margin = TRUE,
  sort = NULL,
  main = "",
  palette = "PRGn",
  rowstat = "median",
  xlim,
  bottom.ylim = NULL,
  right.xlim = NULL,
  gcol = 1
)
}
\arguments{
\item{x}{a matrix of N rows and P columns, where P is the number of time series and N is the number of observations per series}

\item{group}{a length N vector indicating group membership of each row of the matrix (optional)}

\item{xtime}{a length N vector containing the time index (optional)}

\item{norm}{normalization technique (see Details)}

\item{levels}{number of levels for mapping categories into colors}

\item{smooth.df}{the number of degrees of freedom to be used for the spline smoother}

\item{margin}{should the margin plots be shown (default = TRUE)}

\item{sort}{a function computing a numerical statistic that can be used for ordering the rows (default is no sorting)}

\item{main}{title for the plot}

\item{palette}{name of the Color Brewer palette to be used}

\item{rowstat}{a function computing a numerical statistic on the rows for displaying on the margin (default is \code{median})}

\item{xlim}{limits for the x-axis}

\item{bottom.ylim}{y-axis limits for the bottom margin}

\item{right.xlim}{x-axis limits for the right margin}

\item{gcol}{color for lines separating groups}
}
\description{
A function for plotting multivariate time series data
}
\details{
For the normalization, specifying "internal" means that each time series is categorized into colors based on the range of values in each time series individually. Therefore, under this scenario, the same color in two different time series will have two different meanings. If "global" is specified, then each time series will be categorized based on the range of values for the entire collection of time series. In this case, the colors are comparable across series.
}
\examples{
library(mvtsplot)

set.seed(971)
x1 <- matrix(-0.005 * (1:200) + rnorm(200 * 10), 200, 10)
x2 <- matrix(-0.005 * (1:200) + rnorm(200 * 10, mean = 2, sd = 2), 200, 10)
x <- cbind(x1, x2)
colnames(x) <- paste("X", 1:ncol(x))
g <- gl(2, 10)

## Internal normalization
mvtsplot(x, margin = FALSE, norm = "internal", group = g)

## Global normalization
mvtsplot(x, margin = FALSE, norm = "global", group = g)

## Use margin plots
mvtsplot(x, group = g, levels = 7)



}
\references{
Peng RD (2008). "A method for visualizing multivariate time series data," Journal of Statistical Software, 25 (Code Snippet), 1--17.
}
\keyword{graphics}
