% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspProcessData.R
\name{mspProcessData}
\alias{mspProcessData}
\title{Simulate Normal or Fault Observations from a Single-State or Multi-State
Process}
\usage{
mspProcessData(
  faults,
  period = 7 * 24 * 60,
  faultStartIndex = round(0.8433 * period),
  startTime = "2015-05-16 10:00:00 CST",
  multiState = TRUE,
  angles2 = list(yaw = 0, pitch = 90, roll = 30),
  scales2 = c(1, 0.5, 2),
  angles3 = list(yaw = 90, pitch = 0, roll = -30),
  scales3 = c(0.25, 0.1, 0.75),
  adpcaTest = FALSE,
  msadpcaTest = FALSE,
  ...
)
}
\arguments{
\item{faults}{A character vector of faults chosen. Options are "NOC", "A1",
"B1", "C1", "A2", "B2", "C2", "A3", "B3", "C3", or "All". See details for
more information.}

\item{period}{The observation cycle length. Defaults to one week's worth of
minute-level observations (10,080 observations).}

\item{faultStartIndex}{An integer specifying the index at which the faults
will start. Defaults to roughly 85 percent through the cycle.}

\item{startTime}{a POSIXct object specifying the day and time for the
starting observation.}

\item{multiState}{Should the observations be generated from a multi-state
process? Defaults to TRUE.}

\item{angles2}{Change the principal angles for State 2. Defaults to yaw = 0,
pitch = 90, and roll = 30.}

\item{scales2}{Change the principal scales for State 2. Defaults to 1, 0.5,
and 2.}

\item{angles3}{Change the principal angles for State 3. Defaults to yaw = 90,
pitch = 0, and roll = -30.}

\item{scales3}{Change the principal scales for State 3. Defaults to 0.25,
0.1, and 0.75.}

\item{adpcaTest}{If "multiState" is TRUE, incorrectly label all the states
the same. This should only be used to test AD-PCA performance under a true
multi-state model. Defaults to FALSE.}

\item{msadpcaTest}{If "multiState" is FALSE, incorrectly label all the states
at random. This should only be used to test MSAD-PCA performance under a
true single-state model. Defaults to FALSE.}

\item{...}{Lazy dots for internal arguments}
}
\value{
A list of data frames named with the names of the given faults with
  the following information: \describe{
    \item{dateTime -- }{A POSIXct column of times starting at the user-
      defined `startTime` argument, length given by the `period` argument,
      and spacing given by the `increment` argument. For example, if the
      starting value is "2016-01-10", period is 10080, and the incrementation
      is in minutes, then this sequence will be one week's worth of
      observations recorded every minute from midnight on the tenth of
      January.}
    \item{state -- }{An integer column of all 1's (when the `multiState`
      argument is FALSE), or a column of the state values (1, 2 or 3).}
    \item{altState -- }{If either adpcaTest or msadpcaTest are TRUE, this
      column will contain incorrect state information used for testing the
      different treatment arms against their respective controls.}
    \item{x -- }{A double column of generated values for the first feature.}
    \item{y -- }{A double column of generated values for the second feature.}
    \item{z -- }{A double column of generated values for the third feature.}
    }
  If the user only specifies one fault, then this function will return the
  single xts matrix, instead of a list of one matrix. For details on how
  these features are defined, see the "details" of the processNOCdata()
  function.
}
\description{
Generate single- or multi-state observations under normal
  operating conditions or under fault conditions.
}
\details{
For details on how the faults are induced, see the "details" of the
  faultSwitch() function. This function also includes AD-PCA versus MSAD-PCA
  treatment arm testing. There are four possibilities to test: \describe{
    \item{1. }{The true process has one state, and we correctly assume the
    true process has one state. In this case, AD-PCA and MSAD-PCA are exactly
    the same. Draw observations from this state by setting the "multiState"
    argument to FALSE. The "state" label will correctly mark each observation
    as from the same state.}
    \item{2. }{The true process has one state, but we incorrectly assume the
    true process has multiple states. In this case, AD-PCA should outperform
    MSAD-PCA in false alarm rates and waiting time to the first alarm. Draw
    observations from this state by setting the "multiState" argument to
    FALSE and the "msadpcaTest" argument to TRUE. The "state" label will be
    contain randomly generated state values (1, 2, and 3 are all equally
    likely) for each observation.}
    \item{3. }{The true process has multiple states, but we incorrectly
    assume the true process has one single states. In this case, MSAD-PCA
    should outperform AD-PCA in false alarm rates and waiting time to the
    first alarm. Draw observations from this state by setting the "multiState"
    argument to TRUE and the "adpcaTest" argument to TRUE. The "state" label
    will be identical for each observation.}
    \item{4. }{The true process has multiple states, and we correctly assume
    the true process has multiple states. In this case, MSAD-PCA
    should outperform AD-PCA in false alarm rates and waiting time to the
    first alarm. Draw observations from this state by setting the "multiState"
    argument to TRUE. The "state" label will correctly mark each observation
    as from the same state.}
  }
}
\examples{

\dontrun{# cut down on R CMD check time

   mspProcessData(faults = "All")

}
}
\seealso{
Calls: \code{\link{processNOCdata}}, \code{\link{faultSwitch}},
  \code{\link{dataStateSwitch}}. Simulation pipe flow: \code{mspProcessData}
  into \code{\link{mspTrain}} into \code{\link{mspMonitor}} into
  \code{\link{mspWarning}}.
}
