% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{point_on_flat}
\alias{point_on_flat}
\title{Generate one point on arbitrary combination of hyperplanes}
\usage{
point_on_flat(rows, card, ineqmat = NULL, edo = 12, rounder = 10)
}
\arguments{
\item{rows}{Integer vector: which rows of \code{ineqmat} should be taken
as hyperplanes defining the target flat?}

\item{card}{Integer: the number of notes in your desired scale.}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to strings "white," "black", "gray", "roth", "infrared",
"pastel", "rosy", "infrared", or "anaglyph", giving the \code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}},
\code{\link[=make_black_ineqmat]{make_black_ineqmat()}}, \code{\link[=make_gray_ineqmat]{make_gray_ineqmat()}}, \code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}}, \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, or \code{\link[=make_anaglyph_ineqmat]{make_anaglyph_ineqmat()}}. For other
arrangements, this parameter accepts explicit matrices.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric vector of length \code{card} which lies on the specified
hyperplanes. If the intersection of the hyperplanes is empty,
throws a warning and returns a vector of \code{NA}s with length \code{card}.
}
\description{
Given a hyperplane arrangement (specified by \code{ineqmat}) and a subset
of those hyperplanes (specified numerically as the \code{rows} of \code{ineqmat}),
determine some point that lies on the intersection of those hyperplanes.
If the chosen hyperplanes do not all intersect in at least one point,
returns \code{NA}s and throws a warning. This function exists mostly for the
sake of calculations about a hyperplane arrangement itself, not for
musical applications: its results are often not very scale-like (e.g.,
they often fail \code{\link[=optc_test]{optc_test()}}).
}
\examples{
# Works essentially like an inverse of whichsvzeroes():
test_set <- sc(5, 32)
whichsvzeroes(test_set)
generated_point <- point_on_flat(c(5, 8, 10), card=5)
whichsvzeroes(generated_point)

# But note that the given point might lie on any face of the flat:
signvector(test_set)
signvector(generated_point)

# Works for other hyperplane arrangements:
point_on_flat(c(2, 3, 6), card=3, ineqmat="roth")
point_on_flat(c(2, 4), card=4, ineqmat="black")

# Not all combinations of hyperplanes admit a solution:
try(point_on_flat(c(1, 2, 3), card=3, ineqmat="roth"))

}
\seealso{
\code{\link[=match_flat]{match_flat()}} and \code{\link[=populate_flat]{populate_flat()}} are intended for more
concretely musical applications, returning a set on the chosen flat
which is similar to an input set.
}
