% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_along_line.R
\name{move_to_hyperplane}
\alias{move_to_hyperplane}
\title{Intersection of a line with a hyperplane}
\usage{
move_to_hyperplane(
  row,
  set = NULL,
  point = NULL,
  direction = NULL,
  ineqmat = NULL,
  method = c("taxicab", "euclidean", "chebyshev", "hamming"),
  edo = 12,
  rounder = 10
)
}
\arguments{
\item{row}{Integer specifying the hyperplane to be intersected as a row of \code{ineqmat}.}

\item{set}{Numeric vector representing a scale. Defaults to \code{NULL}; if specified, will
give the intersecting line as the scale's "hue."}

\item{point}{Numeric vector representing a point on the line. Overridden by \code{set}.}

\item{direction}{Numeric vector representing the direction of the line. Overridden by \code{set}.}

\item{ineqmat}{Specifies which hyperplane arrangement to consider. By default (or by
explicitly entering "mct") it supplies the standard "Modal Color Theory" arrangements
of \code{\link[=getineqmat]{getineqmat()}}, but can be set to strings "white," "black", "gray", "roth", "infrared",
"pastel", "rosy", "infrared", or "anaglyph", giving the \code{ineqmat}s of \code{\link[=make_white_ineqmat]{make_white_ineqmat()}},
\code{\link[=make_black_ineqmat]{make_black_ineqmat()}}, \code{\link[=make_gray_ineqmat]{make_gray_ineqmat()}}, \code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, \code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}}, \code{\link[=make_rosy_ineqmat]{make_rosy_ineqmat()}},
\code{\link[=make_infrared_ineqmat]{make_infrared_ineqmat()}}, or \code{\link[=make_anaglyph_ineqmat]{make_anaglyph_ineqmat()}}. For other
arrangements, this parameter accepts explicit matrices.}

\item{method}{What distance metric should be used? Defaults to \code{"taxicab"}
but can be \code{"euclidean"}, \code{"chebyshev"}, or \code{"hamming"}.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
A list with three entries: \code{set}, \code{dist}, and \code{sign}. \code{set} is a numeric vector with the
intersection point of the given line and hyperplane. \code{dist} gives the voice-leading distance
(as measured using \code{method}) from input \code{set} or \code{point} to the result \code{set}. \code{sign} indicates
whether the intersection point lies along the given \code{direction} or opposite it. (For instance,
when a hue is specified by input \code{set}, a positive \code{sign} indicates that the intersection belongs
to the same color as input \code{set}, whereas a negative \code{sign} indicates that the intersection is a
scalar involution of the input.)

If the line lies entirely on the given hyperplane, the returned \code{set} simply matches the input,
while \code{dist} and \code{sign} are 0. If the line and hyperplane do not intersect, the result \code{set} is
a vector of \code{NA}s the same length as the input \code{set} or \code{point}; \code{dist} is \code{Inf} and \code{sign} is \code{NA}.
In both of these cases, a warning is given.
}
\description{
Navigate scale space by finding the point where a given line intersects with
a given hyperplane. Hyperplanes are specified by the \code{row} and \code{ineqmat} parameters.
That is, the hyperplane is given by the \code{row}th row of the specified \code{ineqmat}. An
arbitrary hyperplane can be specified by entering \code{row=1} with the desired hyperplane
as a 1-row matrix as the input to \code{ineqmat}.

For the line, two different use cases are available. In the first, \code{set} is specified.
In this case, the line in question is the given \code{set}'s "hue" (i.e., the line which runs
from \code{\link[=edoo]{edoo()}} to \code{set}). This is useful when exploring non-central arrangements such as
the Rothenberg arrangements (\code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}}); for an arrangement centered on \code{\link[=edoo]{edoo()}},
it will simply return \code{\link[=edoo]{edoo()}}. In the second, \code{set} is left \code{NULL} and both \code{point} and
\code{direction} must be specified. Here, the given line is the one which runs through \code{point} parallel
to the vector specified by \code{direction}.
}
\examples{
major_triad <- c(0, 4, 7)
# Let's find where the major triad's hue first intersects a Rothenberg hyperplane:
move_to_hyperplane(3, set=major_triad, ineqmat="roth")
same_hue(major_triad, c(0, 4, 6))
strictly_proper(major_triad)
strictly_proper(c(0, 4, 6))

# But the major triad's hue intersects every MCT hyperplane at the center of the space:
move_to_hyperplane(3, set=major_triad, ineqmat="mct")

# Let's move away from the major triad in other directions than its hue:
lower_third <- c(0, -1, 0)
move_to_hyperplane(1, point=major_triad, direction=lower_third)
move_to_hyperplane(2, point=major_triad, direction=lower_third)
move_to_hyperplane(3, point=major_triad, direction=lower_third)

}
