% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_code.R
\name{get_code}
\alias{get_code}
\title{Code corresponding to a single analysis}
\usage{
get_code(.code, .assgn = NULL)
}
\arguments{
\item{.code}{Code that is passed to the multiverse. This is not stripped of calls such as \code{branch_assert()}.}

\item{.assgn}{A list containing the assignments for each defined parameter in the multiverse}
}
\description{
Given a particular set of options for each parameter, extracts the code for performing a
single analysis from the code used to declare the multiverse. This function is called automatically 
and not exported.
}
\details{
For a particular parameter assignment (i.e. one set of options that each defined parameter
in the multiverse takes), this function rewrites the code passed into the multiverse to output the
corresponding code for that set of parameter values --- the analysis for a single universe.

This is primarily going to be called by other functions, and perhaps not going to be as useful to
the user for anything other than inspecting the rewritten code.
}
