% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{group_means}
\alias{group_means}
\title{Compute column-wise mean in X for each factor level of Y}
\usage{
group_means(Y, X)
}
\arguments{
\item{Y}{a vector of labels to compute means over disjoint sets}

\item{X}{a data matrix from which to compute means}
}
\value{
a matrix with row names corresponding to factor levels of Y and column-wise means for each factor level
}
\description{
This function computes group means for each factor level of Y in the provided data matrix X.
}
\examples{
# Example data
X <- matrix(rnorm(50), 10, 5)
Y <- factor(rep(1:2, each = 5))

# Compute group means
gm <- group_means(Y, X)
}
