% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivarObjectClass.R
\docType{class}
\name{multivar-class}
\alias{multivar-class}
\title{multivar object class}
\description{
An object class to be used with cv.multivar
}
\details{
To construct an object of class multivar, use the function \code{\link{constructModel}}
}
\section{Slots}{

\describe{
\item{\code{k}}{Numeric. The number of subjects (or groupings) in the dataset.}

\item{\code{n}}{Numeric Vector. Vector containing the number of timepoints for each dataset.}

\item{\code{d}}{Numeric Vector. Vector containing the number of variables for each dataset.}

\item{\code{Ak}}{List. A list (length = k) of lagged (T-lag-horizon) by d multivariate time series.}

\item{\code{bk}}{List. A list (length = k) of (T-lag-horizon) by d multivariate time series.}

\item{\code{Hk}}{List. A list (length = k) of (horizon) by d multivariate time series.}

\item{\code{A}}{Matrix. A matrix containing the lagged ((T-lag-horizon)k) by (d+dk) multivariate time series.}

\item{\code{b}}{Matrix. A matrix containing the non-lagged ((T-lag-horizon)k) by (d) multivariate time series.}

\item{\code{H}}{Matrix. A matrix containing the non-lagged (horizon k) by d multivariate time series.}

\item{\code{lag}}{Numeric. The VAR order. Currently only lag 1 is supported.}

\item{\code{horizon}}{Numeric. Forecast horizon.}

\item{\code{t1}}{Numeric vector. Index of time series in which to start cross validation for individual k.}

\item{\code{t2}}{Numeric vector. Index of time series in which to end cross validation for individual k.}

\item{\code{lambda1}}{Numeric vector. Regularization parameter 1.}

\item{\code{lambda2}}{Numeric vector. Regularization parameter 2.}

\item{\code{nlambda1}}{Numeric. Number of lambda1 values to search over. Default is 30.}

\item{\code{nlambda2}}{Numeric. Number of lambda2 values to search over. Default is 30.}

\item{\code{tol}}{Numeric. Convergence tolerance.}

\item{\code{depth}}{Numeric. Depth of grid construction. Default is 1000.}

\item{\code{window}}{Numeric. Size of rolling window.}

\item{\code{standardize}}{Logical. Default is true. Whether to standardize the individual data.}

\item{\code{weightest}}{Character. How to estimate the first-stage weights. Default is "lasso". Other options include "ridge", "ols" and "var".}

\item{\code{canonical}}{Logical. Default is false. If true, individual datasets are fit to a VAR(1) model.}

\item{\code{threshold}}{Logical. Default is false. If true, and canonical is true, individual transition matrices are thresholded based on significance.}

\item{\code{lassotype}}{Character. Default is "adaptive". Choices are "standard" or "adaptive" lasso.}

\item{\code{intercept}}{Logical. Default is FALSE.}

\item{\code{W}}{Matrix. Default is NULL.}

\item{\code{ratios}}{Numeric vector. Default is NULL.}

\item{\code{cv}}{Character. Default is "blocked" for k-folds blocked cross-validation. rolling window cross-validation also available using "rolling".  If "blocked" is selected the nfolds argument should be specified.}

\item{\code{nfolds}}{Numeric. The number of folds for use with "blocked" cross-validation.}

\item{\code{thresh}}{Numeric. Post-estimation threshold for setting the individual-level coefficients to zero if their absolute value is smaller than the value provided. Default is zero.}

\item{\code{lamadapt}}{Logical. Should the lambdas be calculated adaptively. Default is FALSE.}
}}

\seealso{
\code{\link{constructModel}}
}
