% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling_polytope.R
\name{sampling_multinom}
\alias{sampling_multinom}
\alias{sampling_binom}
\title{Posterior Sampling for Inequality-Constrained Multinomial Models}
\usage{
sampling_multinom(
  k,
  options,
  A,
  b,
  V,
  prior = rep(1, sum(options)),
  M = 5000,
  start,
  burnin = 10,
  progress = TRUE,
  cpu = 1
)

sampling_binom(
  k,
  n,
  A,
  b,
  V,
  map = 1:ncol(A),
  prior = c(1, 1),
  M = 5000,
  start,
  burnin = 10,
  progress = TRUE,
  cpu = 1
)
}
\arguments{
\item{k}{the number of choices for each alternative ordered by item type (e.g.
\code{c(a1,a2,a3,  b1,b2)} for a ternary and a binary item type).
The length of \code{k} must be equal to the sum of \code{options}.
The default \code{k=0} is equivalent to sampling from the prior.}

\item{options}{number of observable categories/probabilities for each item
type/multinomial distribution, e.g., \code{c(3,2)} for a ternary and binary item.}

\item{A}{a matrix with one row for each linear inequality constraint and one
column for each of the free parameters. The parameter space is defined
as all probabilities \code{x} that fulfill the order constraints  \code{A*x <= b}.}

\item{b}{a vector of the same length as the number of rows of \code{A}.}

\item{V}{a matrix of vertices (one per row) that define the polytope of
admissible parameters as the convex hull over these points
(if provided, \code{A} and \code{b} are ignored).
Similar as for \code{A}, columns of \code{V} omit the last value for each
multinomial condition (e.g., a1,a2,a3,b1,b2 becomes a1,a2,b1).
Note that this method is comparatively slow since it solves linear-programming problems
to test whether a point is inside  a polytope (Fukuda, 2004) or to run the Gibbs sampler.}

\item{prior}{the prior parameters of the Dirichlet-shape parameters.
Must have the same length as \code{k}.}

\item{M}{number of posterior samples}

\item{start}{only relevant if \code{steps} is defined or \code{cmin>0}:
a vector with starting values in the interior of the polytope.
If missing, an approximate maximum-likelihood estimate is used.}

\item{burnin}{number of burnin samples that are discarded. Can be chosen to be
small if the maxmimum-a-posteriori estimate is used as the (default) starting value.}

\item{progress}{whether a progress bar should be shown (if \code{cpu=1}).}

\item{cpu}{either the number of CPUs using separate MCMC chains in parallel,
or a parallel cluster (e.g., \code{cl <- parallel::makeCluster(3)}).
All arguments of the function call are passed directly to each core,
and thus the total number of samples is \code{M*number_cpu}.}

\item{n}{the number of choices per item type.
If \code{k=n=0}, Bayesian inference is relies on the prior distribution only.}

\item{map}{optional: numeric vector of the same length as \code{k} with integers
mapping the frequencies \code{k} to the free parameters/columns of \code{A}/\code{V},
thereby allowing for equality constraints (e.g., \code{map=c(1,1,2,2)}).
Reversed probabilities \code{1-p} are coded by negative integers.
Guessing probabilities of .50 are encoded by zeros. The default assumes
different parameters for each item type: \code{map=1:ncol(A)}}
}
\value{
an \code{mcmc} matrix (or an \code{mcmc.list} if \code{cpu>1}) with
    posterior samples of the binomial/multinomial probability parameters.
    See \code{\link[coda]{mcmc}}) .
}
\description{
Uses Gibbs sampling to draw posterior samples for binomial and multinomial
models with linear inequality-constraints.
}
\details{
Draws posterior samples for binomial/multinomial random utility models that
assume a mixture over predefined preference orders/vertices that jointly define
a convex polytope via the set of inequalities \code{A * x < b} or as the
convex hull of a set of vertices \code{V}.
}
\examples{
############### binomial ##########################
A <- matrix(
  c(
    1, 0, 0, # x1 < .50
    1, 1, 1, # x1+x2+x3 < 1
    0, 2, 2, # 2*x2+2*x3 < 1
    0, -1, 0, # x2 > .2
    0, 0, 1
  ), # x3 < .1
  ncol = 3, byrow = TRUE
)
b <- c(.5, 1, 1, -.2, .1)
samp <- sampling_binom(c(5, 12, 7), c(20, 20, 20), A, b)
head(samp)
plot(samp)


############### multinomial ##########################
# binary and ternary choice:
#           (a1,a2   b1,b2,b3)
k <- c(15, 9, 5, 2, 17)
options <- c(2, 3)

# columns:   (a1,  b1,b2)
A <- matrix(
  c(
    1, 0, 0, # a1 < .20
    0, 2, 1, # 2*b1+b2 < 1
    0, -1, 0, # b1 > .2
    0, 0, 1
  ), # b2 < .4
  ncol = 3, byrow = TRUE
)
b <- c(.2, 1, -.2, .4)
samp <- sampling_multinom(k, options, A, b)
head(samp)
plot(samp)
}
\references{
Myung, J. I., Karabatsos, G., & Iverson, G. J. (2005). A Bayesian approach to testing decision making axioms. \emph{Journal of Mathematical Psychology, 49}, 205-225. \doi{10.1016/j.jmp.2005.02.004}
}
\seealso{
\code{\link{count_multinom}}, \code{\link{ml_multinom}}
}
