% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_across}
\alias{predict_across}
\title{Predict a Subset of Responses}
\usage{
predict_across(object, newdata, name)
}
\arguments{
\item{object}{An object of class \code{model} containing an estimated model.}

\item{newdata}{A data.frame containing new inputs from which to sample
responses. If NULL, defaults to the data used to estimate fit.}

\item{name}{A string or index specifying which of the dimensions of a
multiresponse prediction to extract.}
}
\value{
A vector of predicted values for the outcome of interest.
}
\description{
Predict across selected responses in a mediation model object. This is a
lower-level version of the predict method that applies to objets of class
mediation_model. Rather than giving predictions across all outcomes, it
supports predictions across a subset specified as a vector. This can be
convenient when we want to analyze how a specific subset of outcomes changes
and do not need to run predictions across all possible.
}
\examples{
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
fit <- multimedia(exper) |>
    estimate(exper)
predict_across(outcome_model(fit), NULL, "outcome_1")

# predict at newdata
newdata <- bind_mediation(exper)
predict_across(
    outcome_model(fit),
    newdata[seq_len(5), ],
    c("outcome_1", "outcome_2")
)
}
