% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mland_plot.R
\name{mland_plot}
\alias{mland_plot}
\title{Plots landscapes from 'MultiLand' objects}
\usage{
mland_plot(
  x,
  raster = NULL,
  points = NULL,
  radii = NULL,
  ext_raster = NULL,
  title = "id",
  ncol = NULL,
  nrow = NULL,
  st_points = list(shape = 21, size = 2, col = "black", fill = "white", alpha = 1),
  st_buffers = list(lty = 1, lwd = 1, col = "black", alpha = 0.6),
  st_classes = list(palette = "Spectral", fill = NULL, alpha = NULL, na_value =
    c("white", 1)),
  st_ext = c("chartreuse", "firebrick1")
)
}
\arguments{
\item{x}{An object of class 'MultiLand' generated with \code{\link[=mland]{mland()}}.}

\item{raster, ext_raster}{Numeric. The rasterlayer to be plotted. Only one rasterlayer can be
plotted at the same time, either defined in \code{raster} or \code{ext_raster}.}

\item{points}{Numeric or character vector of points to be plotted. See Details.}

\item{radii}{Numeric vector of radii to be plotted.}

\item{title}{One of the following: "id" to plot titles as each point id (default), or "sitename" to
plot titles as each pre-defined point name in \code{x}. See Details.}

\item{ncol, nrow}{Number of columns and rows wherein individual plots will be arranged.}

\item{st_points}{List of aesthetic arguments for points plotting:
\code{shape} for points shape, \code{size} for points size, \code{col} for
points border color, \code{fill} for points fill color and \code{alpha} for point transparency.}

\item{st_buffers}{List of aesthetic arguments for buffers plotting:
\code{lty} for buffers linetype, \code{lwd} for buffers linewidth,
\code{col} for buffers border color and \code{alpha} for border transparency.}

\item{st_classes}{List of aesthetic arguments for classes plotting:
\code{palette}, for classes color palette, \code{fill} a vector of fill colors for classes, \code{alpha}, a vector of
alpha values for classes, and \code{na_value} for the color of NA values. See Details.}

\item{st_ext}{Character vector of length 2, depicting the color for the minimum and maximum values
of the raster defined in \code{ext_raster}.}
}
\value{
Multiple plots (in a unique plotting device) of landscapes around
defined points, radii and classes of a MultiLand object.
}
\description{
Returns multiple plots for each landscape generated from each point and buffer, with their radii and classes,
defined by the user through a 'MultiLand' object (generated by \code{\link[=mland]{mland()}}).
Aesthetic parameters of plots can be customized.
}
\details{
If argument \code{points} is a character vector,
\code{\link[=mland_plot]{mland_plot()}} will assume that the 'MultiLand' object inputted in argument \code{x} was created with
\code{site_ref = TRUE}. This is, there is a column/attribute in points layer data with the names for
each distinct point. Therefore, the inputted values in argument \code{points} will be taken as these
identification names. Otherwise, if a numeric vector is inputted, these values
will be taken as the automatically generated point ids (created when running \code{\link[=mland]{mland()}}).

If \code{title = "sitename"}, the title of individual plots will be the names of each point. For this,
the names of the points in \code{x} must had been defined when the object was created with \code{\link[=mland]{mland()}}
(i.e. \code{x@site_ref = TRUE}). Otherwise, the argument will be ignored and the titles will be the
ids of the points.

A pre-defined palette can be chosen to differentiate classes inside \code{palette = "palette_name"},
inside the list defined in \code{st_classes}. Any palette from \code{\link[=hcl.pals]{hcl.pals()}} can be chosen. Otherwise,
the user can define specific colors for each class, inside \code{fill}. This must be a vector built
with concatenated pair of values, the first value being the class (or class name, if defined
during \code{x} generation), and the second value the color (either the name of the color or the hex
code of the color). For example, in the case the rasterlayer has four unique values: (1, 2, 3 and 4), a plausible color definition
could be the following:

\preformatted{
 list(c(1, "green", 2, "red", 3, "black", 4, "yellow"))
}
}
\examples{
\donttest{
# Loads a 'MultiLand' object
ernesdesign <- system.file("extdata", "ernesdesign.zip", package = "multilandr")
ernesdesign <- mland_load(ernesdesign)

# Plots all points and radii
mland_plot(ernesdesign)

# Plots points 1 to 3 and only radius 3000 m
mland_plot(ernesdesign, points = 1:3, radii = 3000)

# Plot with pre-defined colors, and specifying other arguments
cols <- c(1, "forestgreen",
          2, "darkolivegreen2",
          3, "firebrick3",
          4, "goldenrod1",
          5, "deepskyblue3",
          6, "black")

mland_plot(ernesdesign, points = 9:11, radii = c(1000, 2000, 3000),
           title = "sitename", nrow = 1,
           st_points = list(shape = 9),
           st_buffers = list(lty = "dashed"),
           st_classes = list(fill = cols))

# Plot a unique landscape by calling it with its name
mland_plot(ernesdesign, points = "Peje", title = "sitename",
           st_points = list(shape = 15, col = "red"),
           st_classes = list(palette = "Hawaii"))

# Plot extra rasterlaer
mland_plot(ernesdesign, radii = 3000, ext_raster = 1, title = "sitename")

# Plot extra rasterlater with customized colors
mland_plot(ernesdesign, radii = 3000, ext_raster = 1, title = "sitename",
           st_ext = c("blue", "red"))
}
}
