% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_corr.R
\name{metrics_corr}
\alias{metrics_corr}
\title{Pairwise metric correlations}
\usage{
metrics_corr(
  x,
  method = "pearson",
  fun = NULL,
  raster = NULL,
  classes = NULL,
  radii = NULL,
  c_level = NULL,
  l_level = NULL,
  ext_raster = NULL,
  show_class_names = FALSE,
  display = "radii",
  ...
)
}
\arguments{
\item{x}{An object of class 'MultiLandMetrics' generated with \code{\link[=mland_metrics]{mland_metrics()}}.}

\item{method}{The method to be used to calculate pair correlations: "pearson" (default),
"spearman" or "kendall".}

\item{fun}{A user-defined function to calculate correlations. See Details.}

\item{raster, ext_raster, classes, radii, l_level, c_level}{Parameters to subset calculations of
correlations. See Details.}

\item{show_class_names}{Logical. If TRUE, row and column of returned matrices will be identified
with the names of the classes, if available in \code{x}. Default FALSE.}

\item{display}{Defines how correlations are presented: "radii" (default), "rl" or "both".
See Details.}

\item{...}{Other arguments passed to function \code{\link[=cor]{cor()}} or to the user-defined function provided
in \code{fun}.}
}
\value{
A list with matrices containing correlation values between pair of metrics. Matrices
are disaggregated by radius if \code{display = "radii"}, by rasterlayer if \code{display = "rl"} or by
rasterlayer and radii if \code{display = "both"}. Metrics
names are presented as row and column names of the matrices, with the following format:
"level"\emph{"metric_name"}"radius". For a landscape-level metric, a plausible metric name could be
"l_np_1500" indicating a landscape-level metric, which is "np" ("number of patches") at a scale
(radius) of 1500 m. For a class-level metric a plausible metric name could be "c4_pland_1000",
indicating a class-level metric of class 4 (the value of the raster), which is "pland"
("percentage of landscape") at a scale (radius) of 1000 m. If more that one raster layer is
being analyzed, the prefix "r1", "r2", "r3", ..., "rn" (referring to raster layer 1, 2, 3, ..., n) is
added to the metric name.
}
\description{
Calculates pairwise correlations between landscape metrics.
}
\details{
Correlations are calculated, by default, through the function \code{\link[=cor]{cor()}}, by specifying
the method through the argument \code{method}. Alternatively, a user-defined function can be provided
in the argument \code{fun}. If not NULL, the function will assume that a user-defined function
have been provided. This must be a function already loaded in the environment, and
must take at least two arguments. These initial pair of arguments should be capable of receiving
two numeric vectors (one in each argument), process them in some way, and return a numeric
value (i.e. the supposed correlation).

Arguments \code{raster}, \code{ext_raster}, \code{classes}, \code{radii}, \code{c_level} and \code{l_level} can be defined to
subset the calculations of pair correlations. In each one of these, an all-positive or an
all-negative vector can be passed, whether to include (all-positive) or exclude (all-negative)
the elements to be taken into account for the subsetting:
\itemize{
\item raster: a numeric vector with the number of the raster layers to be included/excluded.
For example: \code{c(1, 2, 4)} to include raster layers 1, 2 and 4; \code{c(-2, -3)} to exclude raster layers 2
and 3.
\item ext_raster: a numeric vector with the number of the extra raster layers to be included/excluded,
as in the raster slot.
\item classes: must be a list with as many elements as defined raster layers in argument
\code{raster}. Each element of the list must be a numeric vector (classes identities) with the
classes to be included/excluded. If provided a character vector, \code{\link[=metrics_corr]{metrics_corr()}} assumes that
classes names are provided. For example, for the case with 2 raster layers:
\code{list(c(3, 20, 35), c("Forest", "Crops"))} would include classes 3, 20 and 35 from raster layer 1
and classes "Forest" and "Crops" for raster layer 2. For the case of a unique raster layer, there
is no need to input a list. For example, for the case of a unique raster layer and the
exclusion of some classes: \code{c(-5, -10, -15)} to exclude classes 5, 10 and 15 of
the unique raster layer; \code{c("-Forest", "-Grassland")} to exclude classes "Forest" and "Grassland".
Note the "-" before each class name to indicate the exclusion of the classes.
\item radii: a numeric vector to include/exclude particular radii. For example: \code{c(1000, 2000)} to
include only radii of 1000 and 2000 m; \code{c(-500, -1500)} to exclude radii of 500 and 1500 m.
\item c_level: character vector with the class-level metrics to be included/excluded from
the analysis. For example: \code{c("np", "pland")} will include only the metrics "number of patches"
("np") and "percentage of the landscape" ("pland") in the analysis, whereas \code{c("-np", "-pland")}
will exclude them. Note the "-" before each metric name to indicate the exclusion of the
metrics.
\item l_level: character vector with the landscape-level metrics to be included/excluded from
the analysis. Other calculations for extra raster layers are considered as landscape-level metrics,
and must be provided as "fun_" + the name of the function (e.g. "fun_mean").
}

Names of the available metrics of the 'MultiLandMetrics' object provided in \code{x} can
be accessed with \code{x@metrics} and \code{x@ext_calc}.

Note that patch-level metrics, if exists in \code{x} metric's data.frame, are excluded from
calculations, as this function works at a landscape scale.

Argument \code{display} defines how correlation values will be presented. If equals to "radii"
(default), correlation values are disaggregated by radii. If "rl", correlation values are
disaggregated by rasterlayer: correlations between different radii will be presented.
If "both", correlation values are firstly disaggregated by rasterlayer, and by radii secondly.
Disaggregations by raster layers only make sense for 'MultiLandMetrics' objects with more than one raster layer.
}
\examples{
# Calculates pearson correlations between metrics of a MultiLandMetrics object
metrics_corr(ed_metrics)

# Only for radius 5000 m and with classes names rather than classes values
metrics_corr(ed_metrics, radii = 5000, show_class_names = TRUE)

# Only selecting the metric "pland"
metrics_corr(ed_metrics, radii = 5000, show_class_names = TRUE, c_level = "pland")

# Excluding the metric "pland"
metrics_corr(ed_metrics, radii = 5000, show_class_names = TRUE, c_level = "-pland")

# Excluding the metric radii of 4000 and 5000 m
metrics_corr(ed_metrics, radii = c(-4000, -5000), show_class_names = TRUE)

# Correlations of metric "pland" between classes 1 to 3, and between radii
# 1000 and 5000 m, disaggregating by rasterlayer.
metrics_corr(ed_metrics, radii = c(1000, 5000), classes = 1:3,
             c_level = "pland", display = "rl")
}
\seealso{
\code{\link[=mland_metrics]{mland_metrics()}}, \code{\link[=metrics_plots]{metrics_plots()}}
}
