% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_mfpcs.R
\name{prune_mfpc}
\alias{prune_mfpc}
\title{Prune the MFPC object to include only a prespecified level of explained var}
\usage{
prune_mfpc(MFPC, mfpc_cutoff, model_list, mfpc_cut_method, number_mfpc,
  mfpca_info)
}
\arguments{
\item{MFPC}{List containing MFPC objects for each variance component as given
by the function conduct_mfpca()}

\item{mfpc_cutoff}{Pre-specified level of explained variance of results of
MFPCA. Defaults to 0.95.}

\item{model_list}{List containing sparseFLMM objects for each dimension as
given by the output of apply_sparseFLMM()}

\item{mfpc_cut_method}{Method to determine the level of explained variance
\itemize{
  \item total_var: (weighted) sum of variation over the dimensions.
  \item unidim: separate on each dimension.
}}

\item{number_mfpc}{List containing the number of mfPCs needed for each
variance component e.g. list("E" = x, "B" = y).}

\item{mfpca_info}{Object containing all the neccessary information for the
MFPCA. List as given by the output of prepare_mfpca().}
}
\description{
This is an internal function contained in the multiFAMM function. This
function takes the MFPCA object and decides how many functional principal
components are to be included in the model.
}
\keyword{internal}
