% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_equalities_binom.R
\name{binom_bf_equality}
\alias{binom_bf_equality}
\title{Computes Bayes Factors For Equality Constrained Binomial Parameters}
\usage{
binom_bf_equality(x, n = NULL, a, b, p = NULL)
}
\arguments{
\item{x}{a vector of counts of successes, or a two-dimensional table (or matrix) with 2 columns, giving the counts of successes
and failures, respectively}

\item{n}{numeric. Vector of counts of trials. Must be the same length as \code{x}. Ignored if \code{x} is a matrix or a table}

\item{a}{numeric. Vector with alpha parameters. Must be the same length as \code{x}. Default sets all alpha parameters to 1}

\item{b}{numeric. Vector with beta parameters. Must be the same length as \code{x}. Default sets all beta parameters to 1}

\item{p}{numeric. Hypothesized probability of success. Must be greater than 0 and less than 1.
Default sets all binomial proportions exactly equal without specifying a specific value.}
}
\value{
Returns a \code{data.frame} containing the Bayes factors \code{LogBFe0}, \code{BFe0}, and \code{BF0e}
}
\description{
Computes Bayes factor for equality constrained binomial parameters.
Null hypothesis \eqn{H_0} states that binomial proportions are exactly equal or
exactly equal and equal to \code{p}.
Alternative hypothesis \eqn{H_e} states that binomial proportions are free to vary.
}
\details{
The model assumes that the data in \code{x} (i.e., \eqn{x_1, ..., x_K}) are the observations of \eqn{K} independent
binomial experiments, based on \eqn{n_1, ..., n_K} observations. Hence, the underlying likelihood is the product of the
\eqn{k = 1, ..., K} individual binomial functions:
\deqn{(x_1, ... x_K) ~ \prod Binomial(N_k, \theta_k)}
Furthermore, the model assigns a beta distribution as prior to each model parameter
(i.e., underlying binomial proportions). That is:
\deqn{\theta_k ~ Beta(\alpha_k, \beta_k)}
}
\note{
The following signs can be used to encode restricted hypotheses: \code{"<"} and \code{">"} for inequality constraints, \code{"="} for equality constraints,
\code{","} for free parameters, and \code{"&"} for independent hypotheses. The restricted hypothesis can either be a string or a character vector.
For instance, the hypothesis \code{c("theta1 < theta2, theta3")} means
\itemize{
\item \code{theta1} is smaller than both \code{theta2} and \code{theta3}
\item The parameters \code{theta2} and \code{theta3} both have \code{theta1} as lower bound, but are not influenced by each other.
}
The hypothesis \code{c("theta1 < theta2 = theta3 & theta4 > theta5")} means that
\itemize{
\item Two independent hypotheses are stipulated: \code{"theta1 < theta2 = theta3"} and \code{"theta4 > theta5"}
\item The restrictions on the parameters \code{theta1}, \code{theta2}, and \code{theta3} do
not influence the restrictions on the parameters \code{theta4} and \code{theta5}.
\item \code{theta1} is smaller than \code{theta2} and \code{theta3}
\item \code{theta2} and \code{theta3} are assumed to be equal
\item \code{theta4} is larger than \code{theta5}
}
}
\examples{
data(journals)
x <- journals$errors
n <- journals$nr_NHST
a <- rep(1, nrow(journals))
b <- rep(1, nrow(journals))
binom_bf_equality(x=x, n=n, a=a, b=b)
}
\references{
\insertRef{damien2001sampling}{multibridge}

\insertRef{gronau2017tutorial}{multibridge}

\insertRef{fruhwirth2004estimating}{multibridge}

\insertRef{sarafoglou2020evaluatingPreprint}{multibridge}
}
\seealso{
Other functions to evaluate informed hypotheses: 
\code{\link{binom_bf_inequality}()},
\code{\link{binom_bf_informed}()},
\code{\link{mult_bf_equality}()},
\code{\link{mult_bf_inequality}()},
\code{\link{mult_bf_informed}()}
}
\concept{functions to evaluate informed hypotheses}
