% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot Heatmap}
\usage{
plot_heatmap(
  reshaped_results,
  ontology_id_colname = "ontology_id",
  ontology_element_colname = "element_id_in_ontology",
  p_value_type_colname = "eFDR",
  p_value_max_threshold = 0.05
)
}
\arguments{
\item{reshaped_results}{data.table in relaxed form, obtained as the output
of the \code{reshape_results} function. The data source for generating the
barplot.}

\item{ontology_id_colname}{Character, specifies the column name that contains
ontology IDs in the input data.}

\item{ontology_element_colname}{Character, specifying the column name that
contains ontology elements or terms in the input data. Default:
'element_id_in_ontology'.}

\item{p_value_type_colname}{Character, specifies the column name for p-values
in the input data. Default is 'eFDR'.}

\item{p_value_max_threshold}{Numeric, representing the maximum p-value
threshold for filtering data. Default is 0.05.}
}
\value{
Returns a ggplot2 heatmap.
}
\description{
Plots heatmap of enriched terms and obtained p-values.
}
\details{
The \code{plot_heatmap} function provides a convenient way to create a ggplot2
heatmap illustrating the significance of enriched terms within ontology
categories based on their associated p-values.
}
\examples{
library(mulea)

# loading and filtering the example ontology from a GMT file
tf_gmt <- read_gmt(file = system.file(package="mulea", "extdata", 
    "Transcription_factor_RegulonDB_Escherichia_coli_GeneSymbol.gmt"))
tf_gmt_filtered <- filter_ontology(gmt = tf_gmt, min_nr_of_elements = 3, 
    max_nr_of_elements = 400)

# loading the example data
sign_genes <- readLines(system.file(package = "mulea", "extdata", 
    "target_set.txt"))
background_genes <- readLines(system.file(
    package="mulea", "extdata", "background_set.txt"))

# creating the ORA model
ora_model <- ora(gmt = tf_gmt_filtered,
    # the test set variable
    element_names = sign_genes, 
    # the background set variable
    background_element_names = background_genes, 
    # the p-value adjustment method
    p_value_adjustment_method = "eFDR", 
    # the number of permutations
    number_of_permutations = 10000,
    # the number of processor threads to use
    nthreads = 2)
# running the ORA
ora_results <- run_test(ora_model)

# reshaping results for visualisation
ora_reshaped_results <- reshape_results(
    model = ora_model,
    model_results = ora_results,
    # choosing which column to use for the indication of significance
    p_value_type_colname = "eFDR")

# Plot heatmap                                        
plot_heatmap(reshaped_results = ora_reshaped_results,
    # the column containing the names we wish to plot
    ontology_id_colname = "ontology_id",
    # column that indicates the significance values
    p_value_type_colname = "eFDR")
}
\seealso{
\code{\link{reshape_results}}
}
