% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/inputs.R
\name{Rating}
\alias{Rating}
\alias{Rating.shinyInput}
\alias{updateRating.shinyInput}
\title{Rating}
\usage{
Rating(...)

Rating.shinyInput(inputId, ..., value = defaultValue)

updateRating.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the `session` argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/rating/}
}
\details{
\itemize{
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item component \code{elementType} \cr Default is - The component used for the root node. Either a string to use a HTML element or a component.
\item defaultValue \code{number} \cr Default is null The default value. Use when the component is not controlled.
\item disabled \code{bool} \cr Default is FALSE If true, the component is disabled.
\item emptyIcon \code{node} \cr Default is StarBorder fontSize="inherit" / The icon to display when empty.
\item emptyLabelText \code{node} \cr Default is 'Empty' The label read when the rating input is empty.
\item getLabelText \code{func} \cr Default is function defaultLabelText(value) return \verb{$value || '0' Star$value !== 1 ? 's' : ''}; Accepts a function which returns a string value that provides a user-friendly name for the current value of the rating. This is important for screen reader users.For localization purposes, you can use the provided translations.Signature:function(value: number) = stringvalue The rating label's value to format.
\item highlightSelectedOnly \code{bool} \cr Default is FALSE If true, only the selected icon will be highlighted.
\item icon \code{node} \cr Default is Star fontSize="inherit" / The icon to display.
\item IconContainerComponent \code{elementType} \cr Default is function IconContainer(props) const value, ...other = props; return span ...other / ; The component containing the icon.Deprecated Use slotProps.icon.component instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item max \code{number} \cr Default is 5 Maximum rating.
\item name \code{string} \cr Default is - The name attribute of the radio input elements. This input name should be unique within the page. Being unique within a form is insufficient since the name is used to generate IDs.
\item onChange \code{func} \cr Default is - Callback fired when the value changes.Signature:function(event: React.SyntheticEvent, value: number | null) = voidevent The event source of the callback.value The new value.
\item onChangeActive \code{func} \cr Default is - Callback function that is fired when the hover state changes.Signature:function(event: React.SyntheticEvent, value: number) = voidevent The event source of the callback.value The new value.
\item precision \code{number} \cr Default is 1 The minimum increment value change allowed.
\item readOnly \code{bool} \cr Default is FALSE Removes all hover effects and pointer events.
\item size \code{'small'| 'medium'| 'large'| string} \cr Default is 'medium' The size of the component.
\item slotProps \verb{\{ decimal?: func| object, icon?: func| object, label?: func| object, root?: func| object \}} \cr Default is The props used for each slot inside.
\item slots \verb{\{ decimal?: elementType, icon?: elementType, label?: elementType, root?: elementType \}} \cr Default is The components used for each slot inside.
\item sx \verb{Array func| object| bool | func| object} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item value \code{number} \cr Default is - The rating value.
}
}
