% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesians.R
\name{WAIC.mtar}
\alias{WAIC.mtar}
\title{Watanabe-Akaike or Widely Available Information Criterion (WAIC) for objects of class \code{mtar}}
\usage{
\method{WAIC}{mtar}(...)
}
\arguments{
\item{...}{one or several objects of the class \emph{mtar}.}
}
\value{
A numeric matrix containing the WAIC values corresponding to each \emph{mtar} object in the input.
}
\description{
This function computes the Watanabe-Akaike or Widely Available Information Criterion (WAIC),
for objects of class \code{mtar}.
}
\examples{
\donttest{
###### Example 1: Returns of the closing prices of three financial indexes
data(returns)
fit1a <- mtar(~ COLCAP + BOVESPA | SP500, data=returns, row.names=Date,
              subset={Date<="2016-03-14"}, dist="Student-t",
              ars=ars(nregim=3,p=c(1,1,2)), n.burnin=2000, n.sim=3000,
              n.thin=2)
fit1b <- update(fit1a,dist="Slash")
fit1c <- update(fit1a,dist="Laplace")
WAIC(fit1a,fit1b,fit1c)

###### Example 2: Rainfall and two river flows in Colombia
data(riverflows)
fit2a <- mtar(~ Bedon + LaPlata | Rainfall, data=riverflows, row.names=Date,
              subset={Date<="2009-04-04"}, dist="Laplace",
              ars=ars(nregim=3,p=5), n.burnin=2000, n.sim=3000, n.thin=2)
fit2b <- update(fit2a,dist="Slash")
fit2c <- update(fit2a,dist="Student-t")
WAIC(fit2a,fit2b,fit2c)

###### Example 3: Temperature, precipitation, and two river flows in Iceland
data(iceland.rf)
fit3a <- mtar(~ Jokulsa + Vatnsdalsa | Temperature | Precipitation,
              data=iceland.rf, subset={Date<="1974-12-21"}, row.names=Date,
              ars=ars(nregim=2,p=15,q=4,d=2), n.burnin=2000, n.sim=3000,
              n.thin=2, dist="Slash")
fit3b <- update(fit3a,dist="Laplace")
fit3c <- update(fit3a,dist="Student-t")
WAIC(fit3a,fit3b,fit3c)
}

}
\seealso{
\link{DIC}
}
