% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.probtrans.R
\name{plot.probtrans}
\alias{plot.probtrans}
\title{Plot method for a probtrans object}
\usage{
\method{plot}{probtrans}(
  x,
  from = 1,
  type = c("filled", "single", "separate", "stacked"),
  ord,
  cols,
  xlab = "Time",
  ylab = "Probability",
  xlim,
  ylim,
  lwd,
  lty,
  cex,
  legend,
  legend.pos = "right",
  bty = "n",
  xaxs = "i",
  yaxs = "i",
  use.ggplot = FALSE,
  conf.int = 0.95,
  conf.type = c("log", "plain", "none"),
  label,
  ...
)
}
\arguments{
\item{x}{Object of class 'probtrans', containing estimated transition
probabilities}

\item{from}{The starting state from which the probabilities are used to plot}

\item{type}{One of \code{"stacked"} (default), \code{"filled"},
\code{"single"} or \code{"separate"}; in case of \code{"stacked"}, the
transition probabilities are stacked and the distance between two adjacent
curves indicates the probability, this is also true for \code{"filled"}, but
the space between adjacent curves are filled, in case of \code{"single"},
the probabilities are shown as different curves in a single plot, in case of
\code{"separate"}, separate plots are shown for the estimated transition
probabilities}

\item{ord}{A vector of length equal to the number of states, specifying the
order of plotting in case type=\code{"stacked"} or \code{"filled"}}

\item{cols}{A vector specifying colors for the different transitions;
default is a palette from green to red, when type=\code{"filled"} (reordered
according to \code{ord}, and 1 (black), otherwise}

\item{xlab}{A title for the x-axis; default is \code{"Time"}}

\item{ylab}{A title for the y-axis; default is \code{"Probability"}}

\item{xlim}{The x limits of the plot(s), default is range of time}

\item{ylim}{The y limits of the plot(s); if ylim is specified for
type="separate", then all plots use the same ylim for y limits}

\item{lwd}{The line width, see \code{\link{par}}; default is 1}

\item{lty}{The line type, see \code{\link{par}}; default is 1}

\item{cex}{Character size, used in text; only used when
type=\code{"stacked"} or \code{"filled"}}

\item{legend}{Character vector of length equal to the number of transitions,
to be used in a legend; if missing, numbers will be used; this and the
legend arguments following are ignored when type="separate"}

\item{legend.pos}{The position of the legend, see \code{\link{legend}};
default is \code{"topleft"}}

\item{bty}{The box type of the legend, see \code{\link{legend}}}

\item{xaxs}{See \code{\link{par}}, default is "i", for type=\code{"stacked"}}

\item{yaxs}{See \code{\link{par}}, default is "i", for type=\code{"stacked"}}

\item{use.ggplot}{Default FALSE, set TRUE for ggplot version of plot}

\item{conf.int}{Confidence level (\%) from 0-1 for probabilities, 
default is 0.95 (95\% CI). Setting to 0 removes the CIs.}

\item{conf.type}{Type of confidence interval - either "log" or "plain" . See
function details for details.}

\item{label}{Only relevant for type = "filled" or "stacked", set to 
"annotate" to have state labels on plot, or leave unspecified.}

\item{\dots}{Further arguments to plot}
}
\value{
No return value
}
\description{
Plot method for an object of class 'probtrans'. It plots the transition
probabilities as estimated by \code{\link{probtrans}}.
}
\details{
Regarding confidence intervals: let \eqn{p} denote a predicted probability,
\eqn{\sigma} its estimated standard error,
and \eqn{z_{\alpha/2}} denote the critical value of the standard normal 
distribution at confidence level \eqn{1 - \alpha}.

The confidence interval of type "plain" is then
\deqn{p \pm z_{\alpha/2} * \sigma}

The confidence interval of type "log", based on the Delta method, is then
\deqn{\exp(\log(p) \pm z_{\alpha/2} * \sigma / p)}
}
\examples{

# transition matrix for illness-death model
tmat <- trans.illdeath()
# data in wide format, for transition 1 this is dataset E1 of
# Therneau and Grambsch (2000)
tg <- data.frame(illt=c(1,1,6,6,8,9),ills=c(1,0,1,1,0,1),
        dt=c(5,1,9,7,8,12),ds=c(1,1,1,1,1,1),
        x1=c(1,1,1,0,0,0),x2=c(6:1))
# data in long format using msprep
tglong <- msprep(time=c(NA,"illt","dt"),status=c(NA,"ills","ds"),
		data=tg,keep=c("x1","x2"),trans=tmat)
# events
events(tglong)
table(tglong$status,tglong$to,tglong$from)
# expanded covariates
tglong <- expand.covs(tglong,c("x1","x2"))
# Cox model with different covariate
cx <- coxph(Surv(Tstart,Tstop,status)~x1.1+x2.2+strata(trans),
	data=tglong,method="breslow")
summary(cx)
# new data, to check whether results are the same for transition 1 as
# those in appendix E.1 of Therneau and Grambsch (2000)
newdata <- data.frame(trans=1:3,x1.1=c(0,0,0),x2.2=c(0,1,0),strata=1:3)
msf <- msfit(cx,newdata,trans=tmat)
# probtrans
pt <- probtrans(msf,predt=0)
# default plot
plot(pt,ord=c(2,3,1),lwd=2,cex=0.75)
# filled plot
plot(pt,type="filled",ord=c(2,3,1),lwd=2,cex=0.75)
# single plot
plot(pt,type="single",lwd=2,col=rep(1,3),lty=1:3,legend.pos=c(8,1))
# separate plots
par(mfrow=c(2,2))
plot(pt,type="sep",lwd=2)
par(mfrow=c(1,1))

# ggplot version - see vignette for details
library(ggplot2)
plot(pt, ord=c(2,3,1), use.ggplot = TRUE)

}
\seealso{
\code{\link{probtrans}}
}
\author{
Hein Putter \email{H.Putter@lumc.nl}

Edouard F. Bonneville \email{e.f.bonneville@lumc.nl}
}
\keyword{hplot}
