% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msp_format.R
\name{ReadMsp}
\alias{ReadMsp}
\title{Read mass spectra from an msp-file (NIST format)}
\usage{
ReadMsp(input_file)
}
\arguments{
\item{input_file}{A string. The name of a file.}
}
\value{
Return a list of nested lists. Each nested list is a mass spectrum. Almost
  all metadata fields (e.g., "Name", "CAS#", "Formula", "MW", etc.) are
  represented as strings. All "Synon" fields are merged into a single
  character vector. Mass values and intensities are represented as numeric
  vectors (\code{mz} and \code{intst}). Names of fields are slightly
  modified:
  \itemize{
    \item names are converted to lowercase;
    \item hash symbols are replaced with \code{_no};
    \item any other special character is replaced with an underscore
    character.
  }
}
\description{
Read an msp-file containing mass spectra in the NIST format. The complete
  description of the format can be found in the NIST Mass Spectral Search
  Program manual. A summary is presented below in the "Description of the
  NIST format" section.
}
\details{
Data from an msp-file are read without any modification (e.g., the order of
  mass values is not changed, zero-intensity peaks are preserved, etc.).
}
\section{Description of the NIST format}{

  The summary was prepared using the NIST Mass Spectral Search Program manual
  v.2.4 (2020).
  \itemize{
    \item An msp-file can contain as many spectra as wanted.
    \item Each spectrum must start with the "Name" field. There must be
    something in this field.
    \item The "Num Peaks" field is also required. It must contain the number
    of mass/intensity pairs.
    \item Some optional fields (e.g. "Comments", "Formula", "MW") can be
    between the "Name" and "Num Peaks" fields.
    \item When a spectrum is exported from the NIST library it also
    contains the "NIST#" and "DB#" fields. The "NIST#" field is on the same
    line as the "CAS#" field and separated by a semicolon.
    \item Each field should be on a separate line (the "NIST#" field is an
    exception from this rule)
    \item The mass/intensity list begins on the line following the "Num
    Peaks" field. The peaks need not be normalized, and the masses need not
    be ordered. The exact spacing and delimiters used for the mass/intensity
    pairs are unimportant. The following characters are accepted as
    delimiters: '\code{space}', '\code{tab}', '\code{,}', '\code{;}',
    '\code{:}'. Parentheses, square brackets and curly braces  ('\code{(}',
    '\code{(}', '\code{[}', '\code{]}', '\code{\{}', and '\code{\}}') are
    also allowed.
    \item The "Name" field can be up to 511 characters.
    \item The "Comments" field can be up to 1023 characters.
    \item The "Formula" field can be up to 23 characters.
    \item The "Synon" field may be repeated.
  }
}

\examples{
# Reading the 'alkanes.msp' file
msp_file <- system.file("extdata", "alkanes.msp", package = "mssearchr")
msp_objs <- ReadMsp(msp_file)

# Plotting the first mass spectrum from the 'msp_objs' list
par_old <- par(yaxs = "i")
plot(msp_objs[[1]]$mz, msp_objs[[1]]$intst,
     ylim = c(0, 1000), main = msp_objs[[1]]$name,
     type = "h", xlab = "m/z", ylab = "Intensity", bty = "l")
par(par_old)

}
